/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USAint
 */

package opale.soya.soya3d.model;

import opale.soya.*;
import opale.soya.util.Lockable;
import opale.soya.util.*;
import opale.soya.awt.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.Point;
import opale.soya.soya3d.transformation.*;
import opale.soya.editor.*;
import java.beans.*;
import java.lang.reflect.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Iterator;

public class FragmentedShapeGUIEditor extends GUIEditor {
  public static void edit(FragmentedShape s) {
    FragmentedShapeGUIEditor sm = new FragmentedShapeGUIEditor(s);
    sm.setVisible(true);
  }
  public static void main(String[] args) {
    Soya.init();
    Shape.path = "/home/aonw/shapes/";
    Material.path = "/home/aonw/materials/";
    FragmentedShapeGUIEditor s = null;
    try {
      if((args != null) && (args.length >= 1)) s = new FragmentedShapeGUIEditor((FragmentedShape) Shape.get(args[0]));
      else s = new FragmentedShapeGUIEditor((FragmentedShape) Shape.get("n-e-nef-c"));
    }
    catch(Exception e) { System.out.println("Can't find or edit shape."); e.printStackTrace();  }
    s.setVisible(true);
  }

  protected void aff(String s) { super.aff(s); }
  protected void setStep(float step) {
    super.setStep(step);
    shapeElementsHandles.setScale(step);
    pointsHandles       .setScale(step);
  }

  private FragmentedShape shape;
  public FragmentedShape getShape() { return shape; }
  public FragmentedShapeGUIEditor(final FragmentedShape s) {
    super(s.getName() + " -- soya GUI shape editor");
    
    shape = s;
    s.addCollectionListener(s_collectionListener);
    
    // Build menu:
    MenuItem file1 = new MenuItem("Save"); fileMenu.add(file1);
    file1.setShortcut(new MenuShortcut(KeyEvent.VK_S));
    file1.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        try { s.save(); aff("Saved."); }
        catch(Exception e2) { aff("Can't save shape : " + s.getName() + " : " + e2); }
      }
    });
    MenuItem file3 = new MenuItem("Optimize and save"); fileMenu.add(file3);
    file3.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        s.optimize();
        try { s.save(); }
        catch(Exception e2) { aff("Can't save shape : " + s.getName() + " : " + e2); }
      }
    });
    
    Menu shapeMenu = new Menu("Shape"); menuBar.add(shapeMenu);
    MenuItem shape1 = new MenuItem("edit..."); shapeMenu.add(shape1);
    shape1.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        try { Editor.edit(shape); }
        catch(Exception ex) { aff("Can't edit shape!"); ex.printStackTrace(); }
      }
    });
    MenuItem shape2 = new MenuItem("dump"); shapeMenu.add(shape2);
    shape2.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        System.out.println("dump of " + shape.getName());
        System.out.println(shape);
      }
    });
    MenuItem shape3 = new MenuItem("-"); shapeMenu.add(shape3);
    MenuItem shape4 = new MenuItem("Translate..."); shapeMenu.add(shape4);
    shape4.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        final Vector v = new Vector();
        try {
          Editor.edit(v).addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
              shape.addVector(v.getX(), v.getY(), v.getZ());
            }
          });
        }
        catch(Exception ex) { System.out.println("Can't edit a vector or can't translate!"); ex.printStackTrace(); }
      }
    });
    MenuItem shape5 = new MenuItem("Scale..."); shapeMenu.add(shape5);
    shape5.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        final Vector v = new Vector(1f, 1f, 1f);
        try {
          Editor.edit(v).addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
              shape.scale(v.getX(), v.getY(), v.getZ());
            }
          });
        }
        catch(Exception ex) { System.out.println("Can't edit a scaling vector or can't scale!"); ex.printStackTrace(); }
      }
    });
    MenuItem shape6 = new MenuItem("Rotate..."); shapeMenu.add(shape6);
    shape6.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        final SimpleRotation r = new SimpleRotation();
        try {
          Editor.edit(r).addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
              //shape.transform(Matrix.matrixRotate(r.getAngle(), r.getX(), r.getY(), r.getZ()));
              shape.transform(r.toMatrix());
            }
          });
        }
        catch(Exception ex) { System.out.println("Can't edit a rotation or can't rotate!"); ex.printStackTrace(); }
      }
    });
    
    Menu faceMenu = new Menu("Face"); menuBar.add(faceMenu);
    MenuItem face1 = new MenuItem("New face"); faceMenu.add(face1);
    face1.setShortcut(new MenuShortcut(KeyEvent.VK_N));
    face1.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { createNewFace(); }
    });
    faceClassMenu = new Menu("Class of face"); faceMenu.add(faceClassMenu);
    addFaceClass("opale.soya.soya3d.model.Triangle");
    addFaceClass("opale.soya.soya3d.model.Quad");
    addFaceClass("opale.soya.soya3d.Label3D");
    addFaceClass("opale.soya.soya3d.geometry.Sphere3D");
    MenuItem face2 = new MenuItem("Edit last created face"); faceMenu.add(face2);
    face2.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if(lastCreatedFragmentedShapeElement == null) return;
        try { Editor.edit(lastCreatedFragmentedShapeElement, false); }
        catch(Exception e2) { aff("Can't edit last created shape element : " + e2); }
      }
    });
    editNewFace = new CheckboxMenuItem("Edit on creation"); faceMenu.add(editNewFace);
    MenuItem face3 = new MenuItem("Remove last face/creating face"); faceMenu.add(face3);
    face3.setShortcut(new MenuShortcut(KeyEvent.VK_DELETE));
    face3.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { cancelFaceCreation(); }
    });
    MenuItem face4 = new MenuItem("Remove last point"); faceMenu.add(face4);
    face4.setShortcut(new MenuShortcut(KeyEvent.VK_BACK_SPACE));
    face4.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { cancelLastPoint(); }
    });
    MenuItem face5 = new MenuItem("Revert"); faceMenu.add(face5);
    face5.setShortcut(new MenuShortcut(KeyEvent.VK_R));
    face5.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { revertSelectedFaces(); }
    });

    Menu pointMenu = new Menu("Point"); menuBar.add(pointMenu);
    MenuItem point1 = new MenuItem("Edit texture coordinates..."); pointMenu.add(point1);
    point1.setShortcut(new MenuShortcut(KeyEvent.VK_T));
    point1.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { editSelectionTextureCoord(); }
    });
    
    Menu selMenu = new Menu("Selection"); menuBar.add(selMenu);
    MenuItem sel1 = new MenuItem("Select points"); selMenu.add(sel1);
    sel1.setShortcut(new MenuShortcut(KeyEvent.VK_P));
    sel1.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { setMode(MODE_SELECTION_POINT); }
    });
    MenuItem sel2 = new MenuItem("Select faces"); selMenu.add(sel2);
    sel2.setShortcut(new MenuShortcut(KeyEvent.VK_F));
    sel2.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { setMode(MODE_SELECTION_FACE); }
    });
    MenuItem sel3 = new MenuItem("Select points on faces"); selMenu.add(sel3);
    sel3.setShortcut(new MenuShortcut(KeyEvent.VK_O));
    sel3.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { setMode(MODE_SELECTION_POINT_INTO_FACE); }
    });
    MenuItem sel4 = new MenuItem("Hide handles"); selMenu.add(sel4);
    sel4.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { setMode(MODE_NO_HANDLES); }
    });
    selMenu.add(new MenuItem("-"));
    MenuItem sel5 = new MenuItem("Edit selection..."); selMenu.add(sel5);
    sel5.setShortcut(new MenuShortcut(KeyEvent.VK_E));
    sel5.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { editSelection(); }
    });
    MenuItem sel6 = new MenuItem("Delete selection..."); selMenu.add(sel6);
    sel6.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { deleteSelection(); }
    });
    
    // Build scene:
    volume.setShape(s);
    world.add(volume);
		
    // Build handles:
    pointsHandles = pointsHandlesFor(shape);
    pointsHandles.addIntoWorld(world);
    pointsHandles.addCollectionListener(new CollectionListener() { // Will automatically add new handles.
      public void added(AddEvent e) { FragmentedShapeGUIEditor.this.getEditionWorld().add((Handle3D) e.getElement()); }
      public void removed(RemoveEvent e) { FragmentedShapeGUIEditor.this.getEditionWorld().remove((Handle3D) e.getElement()); }
    });
    
    shapeElementsHandles = shapeElementsHandlesFor(s);
    shapeElementsHandles.addIntoWorld(world);
    shapeElementsHandles.addCollectionListener(new CollectionListener() { // Will automatically add new handles.
      public void added(AddEvent e) { FragmentedShapeGUIEditor.this.getEditionWorld().add((Handle3D) e.getElement()); }
      public void removed(RemoveEvent e) { FragmentedShapeGUIEditor.this.getEditionWorld().remove((Handle3D) e.getElement()); }
    });
    
    s.addPropertyChangeListener(s_propertyChangeListener);
    
    setMode(MODE_SELECTION_POINT);
    setStep(Editor.getOptions().magneticStep);
    aff("Welcome to soya GUI editor :-) Use mouse and page-up/down keys.");
  }
  public void finalize() throws java.lang.Throwable {
    super.finalize();
    shape.removePropertyChangeListener(s_propertyChangeListener);
    shape.removeCollectionListener(s_collectionListener);
  }
  PropertyChangeListener s_propertyChangeListener = new PropertyChangeListener() {
    public void propertyChange(PropertyChangeEvent e) { FragmentedShapeGUIEditor.this.render(); }
  };
  public void render() {
    super.render();
  }
  CollectionListener s_collectionListener = new CollectionListener() {
    public void added(AddEvent e) {
      FragmentedShapeElement se = (FragmentedShapeElement) e.getElement();
      Handle3D[] h = shapeElementHandlesFor(se);
      for(int i = 0; i < h.length; i++) shapeElementsHandles.add(h[i]);
      //shapeElementsHandles.add(shapeElementHandleFor(se));
      if(se instanceof Face) {
        Face f = (Face) e.getElement();
        Handles hs = pointsHandlesFor(f);
        pointsHandles.addAll(hs);
      }
    }
    public void removed(RemoveEvent e) {
      FragmentedShapeElement se = (FragmentedShapeElement) e.getElement();
      shapeElementsHandles.removeHandlesFor(se);
      if(se instanceof Face) {
        Face f = (Face) se;
        Position[] ps = f.getPoints();
        java.util.Collection c = new java.util.Vector();
        for(int i = 0; i < ps.length; i++) c.add(ps[i]);
        pointsHandles.removeHandlesFor(c);
      }
    }
  };
	
  private Class newFaceClass = opale.soya.soya3d.model.Triangle.class;
  private ActionListener faceClassListener = new ActionListener() {
    public void actionPerformed(ActionEvent e) {
      setFaceClass(((MenuItem) e.getSource()).getLabel());
    }
  };
  private Menu faceClassMenu;
  protected MenuItem addFaceClass(String faceClass) {
    try { return addFaceClass(Class.forName(faceClass)); }
    catch(Exception e) { aff("Can't create the face class for " + faceClass + " : " + e); }
    return null;
  }
  protected MenuItem addFaceClass(Class faceClass) {
    MenuItem m = new MenuItem(faceClass.getName());
    faceClassMenu.add(m);
    m.addActionListener(faceClassListener);
    return m;
  }
  protected void setFaceClass(String className) {
    try {
      newFaceClass = Class.forName(className); 
      aff("new face classe : " + className + " !");
    }
    catch(Exception e2) { aff("Can't create the face class : " + e2); }
  }
	
  private CheckboxMenuItem editNewFace;
	
  private int mode;
  public static final int MODE_SELECTION_POINT = 0;
  public static final int MODE_FACE_CREATION = 1;
  public static final int MODE_SELECTION_FACE = 2;
  public static final int MODE_SELECTION_POINT_INTO_FACE = 3;
  public static final int MODE_NO_HANDLES = 4;
  public int getMode() { return mode; }
  public void setMode(int newMode) {
    switch(mode) {
    case MODE_FACE_CREATION: cancelFaceCreation(); break;
    }
    switch(newMode) {
    case MODE_FACE_CREATION: createNewFace(); break;
    case MODE_SELECTION_POINT:
      mode = newMode; aff("Points selection mode : Select and move one or more points.");
      shapeElementsHandles.setVisible(false);
      pointsHandles.setVisible(true);
      cursor.setHandles(pointsHandles);
      break;
    case MODE_SELECTION_FACE:
      mode = newMode; aff("Faces selection mode : Select and move one or more faces.");
      for(Iterator i = shapeElementsHandles.iterator(); i.hasNext(); ) ((Handle3D) i.next()).update();
      shapeElementsHandles.setVisible(true);
      pointsHandles.setVisible(false);
      cursor.setHandles(shapeElementsHandles);
      break;
    case MODE_SELECTION_POINT_INTO_FACE:
      java.util.Collection pointsOnClickedFaces = new java.util.Vector();
      for(Iterator i = shapeElementsHandles.getClickedObjects().iterator(); i.hasNext(); ) {
        FragmentedShapeElement se = (FragmentedShapeElement) i.next();
        if(se instanceof Face) {
          Position[] ps = ((Face) se).getPoints();
          for(int j = 0; j < ps.length; j++) pointsOnClickedFaces.add(ps[j]);
        }
      }
      if(pointsOnClickedFaces.size() == 0) aff("Can't enter in Points on face selection mode. You must select some faces before, in face selection mode.");
      else {
        mode = newMode; aff("Points on face selection mode : Select and move one or more points in the previous selected faces.");
        shapeElementsHandles.setVisible(false);
        pointsHandles.setVisibleHandlesFor(true, pointsOnClickedFaces);
        cursor.setHandles(pointsHandles);
      }
      break;
    case MODE_NO_HANDLES:
      mode = newMode; aff("No handle mode. Useful for screenshot :-)");
      shapeElementsHandles.setVisible(false);
      pointsHandles.setVisible(false);
      break;
    }
    render();
  }

  // Overrides :	
  protected void mousePressed(MouseEvent e) {
    if((e.getModifiers() & MouseEvent.BUTTON1_MASK) == MouseEvent.BUTTON1_MASK) {
      if(mode == MODE_FACE_CREATION) render(); // Do nothing.
      else super.mousePressed(e);
    }
  }
  protected void mouseReleased(MouseEvent e) {
    if((e.getModifiers() & MouseEvent.BUTTON1_MASK) == MouseEvent.BUTTON1_MASK) {
      if(mode == MODE_FACE_CREATION) {
        addPointToCreatingFace(cursor.getChoosenPosition());
        render();
      }
      else super.mouseReleased(e);
    }
  }
  public void keyPressed(KeyEvent e) {
    //lock();
    switch(e.getKeyCode()) {
    case KeyEvent.VK_BACK_SPACE: cancelLastPoint                      (); break;
    case KeyEvent.VK_DELETE:     cancelFaceCreation                   (); break;
    case KeyEvent.VK_E:          editSelection                        (); break;
    case KeyEvent.VK_T:          editSelectionTextureCoord            (); break;
    case KeyEvent.VK_P:          setMode(MODE_SELECTION_POINT          ); break;
    case KeyEvent.VK_F:          setMode(MODE_SELECTION_FACE           ); break;
    case KeyEvent.VK_O:          setMode(MODE_SELECTION_POINT_INTO_FACE); break;
    case KeyEvent.VK_N:          createNewFace                        (); break;
    case KeyEvent.VK_R:          revertSelectedFaces                  (); break;
    case KeyEvent.VK_G:          System.gc                            (); break;
    case KeyEvent.VK_F3:         setFaceClass("opale.soya.soya3d.model.Triangle"); createNewFace(); break;
    case KeyEvent.VK_F4:         setFaceClass("opale.soya.soya3d.model.Quad"    ); createNewFace(); break;
    case KeyEvent.VK_S:
      try { shape.save(); aff("Saved!"); }
      catch(Exception e2) { aff("Can't save shape : " + shape.getName() + " : " + e2); }
      break;
    default: super.keyPressed(e); break;
    }
    //unlock();
  }

  private Volume3D volume = new Volume3D();
  private Handles pointsHandles;
  private Handles shapeElementsHandles;

  private void deleteSelection() {
    for(Iterator i = cursor.getHandles().getClickedObjects().iterator(); i.hasNext(); ) {
      Object o = i.next();
      if(o instanceof FragmentedShapeElement) shape.remove((FragmentedShapeElement) o);
      else aff("Non-deletable selection!");
    }
  }
  private void editSelection() {
    java.util.Collection ps = new java.util.Vector();
    for(Iterator i = cursor.getHandles().getClickedObjects().iterator(); i.hasNext(); ) {
      Object o = i.next();
      if(o instanceof Position) ps.add(o); // Store them for future regroupment (identical points are edited only once).
      else { // edit.
        try { Editor.edit(o, false); }
        catch(Exception e) { aff("can't edit an element in the selection!"); e.printStackTrace(); }
      }
    }
    for(Iterator i = PointsRegrouper.regroupPoints(ps).iterator(); i.hasNext();) {
      try { Editor.edit(i.next(), false); }
      catch(Exception e) { aff("can't edit an element in the selection!"); e.printStackTrace(); }
    }
  }
  private void revertSelectedFaces() {
    shape.lock();
    for(Iterator i = cursor.getHandles().getClickedObjects().iterator(); i.hasNext(); ) {
      Object o = i.next();
      if(o instanceof Face) {
        ((Face) o).revert();
        aff("Face reverted!");
      }
    }
    shape.unlock();
  }

  private FragmentedShapeElement lastCreatedFragmentedShapeElement;
  private Face creatingFace;
  private int currentPoint;
  private int previousMode;
  private synchronized FragmentedShapeElement createNewFace() {
    if(opale.soya.soya3d.model.Face.class.isAssignableFrom(newFaceClass)) { // A Face.
      if(mode == MODE_FACE_CREATION) cancelFaceCreation();
      else previousMode = mode;
      mode = MODE_FACE_CREATION;
      currentPoint = -1; // No current point.
      try { creatingFace = (Face) newFaceClass.newInstance(); }
      catch(Exception e) { aff("Can't create a face from class " + newFaceClass.getName()); e.printStackTrace(); }
      aff("New face !");
      return creatingFace;
    }
    else {
      try { lastCreatedFragmentedShapeElement = (FragmentedShapeElement) newFaceClass.newInstance(); }
      catch(Exception e) { aff("Can't create a fragment from class " + newFaceClass.getName()); e.printStackTrace(); }
      shape.add(lastCreatedFragmentedShapeElement);
      setMode(MODE_SELECTION_FACE);
      for(Iterator i = shapeElementsHandles.getHandlesFor(lastCreatedFragmentedShapeElement).iterator(); i.hasNext(); ) {
        Handle3D h = (Handle3D) i.next();
        if(h instanceof FragmentedShapeElementHandle3D) {
          cursor.press(new MouseEvent(renderingCanvas, MouseEvent.MOUSE_PRESSED, System.currentTimeMillis(), MouseEvent.BUTTON1_MASK, 0, 0, 0, false), h);
          break;
        }
      }
      aff("New fragment !");
      return lastCreatedFragmentedShapeElement;
    }
  }
  private synchronized void cancelFaceCreation() {
    if(mode == MODE_FACE_CREATION) {
      if(currentPoint != -1) shape.remove(creatingFace); // The face has been added into the shape.
      creatingFace = null;
      mode = previousMode;
      aff("New face canceled !");
    }
    else {
      if(lastCreatedFragmentedShapeElement != null) {
        shape.remove(lastCreatedFragmentedShapeElement);
        lastCreatedFragmentedShapeElement = null;
        aff("Last created face removed !");
      }
      else aff("Can't remove last face ! No face or last created face already removed !");
    }
  }
  private synchronized void addPointToCreatingFace(Position p) {
    p = p.clone(volume); // A shape has no frame so no automatic frame-coordinates conversions are performed!
    p.setCoordSyst(null);
    currentPoint++;
    if(currentPoint == 0) { // first point. Create all the points, in order to show the face.
      for(int i = 0; i < creatingFace.getNumberOfPoints(); i++) {
        Position pos = new AdvancedPoint(p);
        creatingFace.setPoint(i, pos);
      }
      shape.add(creatingFace);
    }
    else creatingFace.getPoint(currentPoint).move(p); // just move the point.
    if((currentPoint + 1) == creatingFace.getNumberOfPoints()) endFaceCreation();
  }
  private synchronized void cancelLastPoint() {
    if((mode != MODE_FACE_CREATION) || (currentPoint == -1)) aff("Can't cancel last point ! Not in face creation mode or no point !");
    else {
      if(currentPoint == 0) {
        shape.remove(creatingFace);
        currentPoint--;
      }
      else {
        creatingFace.getPoint(currentPoint).move(creatingFace.getPoint(0));
        currentPoint--;
      }
      aff("Last point canceled !");
    }
  }
  private synchronized void endFaceCreation() {
    mode = previousMode;
    lastCreatedFragmentedShapeElement = creatingFace;
    creatingFace = null;
    if(editNewFace.getState()) {
      try { Editor.edit(lastCreatedFragmentedShapeElement, false); }
      catch(Exception e) { aff("Can't edit new face"); e.printStackTrace(); }
    }
    aff("New face ended !");
  }

  private synchronized void editSelectionTextureCoord() {
    java.util.Collection ps = new java.util.Vector();
    for(Iterator i = cursor.getHandles().getClickedObjects().iterator(); i.hasNext(); ) {
      Object o = i.next();
      if(o instanceof Position) ps.add(o);
    }
    for(Iterator i = PointsRegrouper.regroupPoints(ps).iterator(); i.hasNext(); ) {
      Object o = i.next();
      if((o instanceof Textured) && (o instanceof Position)) {
        Position p = (Position) o;
        Face f = faceOfPoint(p);
        if(f != null) (new TexturedGUIEditor((Textured) o, f.getMaterial().getTexture(), shape)).setVisible(true);
      }
      else aff("Selection hasn't texture coordinates!");
    }
  }
  private synchronized Face faceOfPoint(Position p) {
    for(Iterator i = shape.iterator(); i.hasNext(); ) { // first try with == ...
      FragmentedShapeElement se = (FragmentedShapeElement) i.next();
      if(se instanceof Face) {
        Face f = (Face) se;
        Position[] ps = f.getPoints();
        int nb = ps.length;
        for(int j = 0; j < nb; j++) {
          if(ps[j] == p) return f;
        }
      }
    }
    for(Iterator i = shape.iterator(); i.hasNext(); ) { // and then with .equals(Object) .
      FragmentedShapeElement se = (FragmentedShapeElement) i.next();
      if(se instanceof Face) {
        Face f = (Face) se;
        Position[] ps = f.getPoints();
        int nb = ps.length;
        for(int j = 0; j < nb; j++) {
          if(ps[j].equals(p)) return f;
        }
      }
    }
    return null;
  }
  
  public synchronized void lock() {
    super.lock();
    shape.lock();
  }
  public synchronized void unlock() {
    if(lockLevel <= 0) return;
    shape.unlock(); // Will call a render.
  }
  
  protected static Handles pointsHandlesFor(FragmentedShape s) {
    Handles hs = new Handles();
    for(Iterator i = s.iterator(); i.hasNext(); ) {
      FragmentedShapeElement se = (FragmentedShapeElement) i.next();
      if(se instanceof Face) hs.addAll(pointsHandlesFor((Face) se));
    }
    return hs;
  }
  protected static Handles pointsHandlesFor(Face f) {
    Handles hs = new Handles();
    Position[] ps = f.getPoints();
    for(int i = 0; i < ps.length; i++) hs.add(pointHandleFor(ps[i]));
    return hs;
  }
  protected static Handle3D pointHandleFor(Position p) { return new ShapePointHandle3D(p); }
  
  protected static Handles shapeElementsHandlesFor(FragmentedShape s) {
    Handles hs = new Handles();
    for(Iterator i = s.iterator(); i.hasNext(); ) {
      FragmentedShapeElement fse = (FragmentedShapeElement) i.next();
      hs.add(new FragmentedShapeElementHandle3D(fse));
      if(fse instanceof Orientation) hs.add(new OrientationHandle3D((Orientation) fse));
    }
    return hs;
  }
  protected static Handle3D[] shapeElementHandlesFor(FragmentedShapeElement se) {
    if(se instanceof Orientation) {
      Handle3D[] hs = { new FragmentedShapeElementHandle3D(se), new OrientationHandle3D((Orientation) se) };
      return hs;
    }
    else {
      Handle3D[] hs = { new FragmentedShapeElementHandle3D(se) };
      return hs;
    }
  }
  //protected static Handle3D shapeElementHandleFor(FragmentedShapeElement se) { return new FragmentedShapeElementHandle3D(se); }
}
