/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.*;
import opale.soya.editor.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.event.*;
import opale.soya.util.*;
import java.awt.event.*;
import java.beans.*;

class FragmentedShapeElementHandle3D extends Handle3D {
  public FragmentedShapeElementHandle3D() { super(BLUE); }
  public FragmentedShapeElementHandle3D(FragmentedShapeElement se) {
    this();
    setFragmentedShapeElement(se);
  }
  public void finalize() {
    if(se != null) se.removePropertyChangeListener(moveListener);
  }

  private FragmentedShapeElement se;
  public FragmentedShapeElement getFragmentedShapeElement() { return se; }
  public Object getEditedObject() { return se; }
  public synchronized void setFragmentedShapeElement(FragmentedShapeElement fragmentedShapeElement) { 
    se = fragmentedShapeElement;
    se.getCenter().addPropertyChangeListener(moveListener);
    update();
    firePropertyChange("fragmentedShapeElement"); 
  }
  private Position p = new Point();

  protected void doSelection(boolean selected) {  }
  protected void doClick(boolean clicked) {  }
  protected synchronized void doMovement(Cursor3D c, Position position, MouseEvent e) {
    Vector v = new Vector(p, position);
    v.setCoordSyst(null);
    CoordSyst cs = se.getCenter().getCoordSyst();
    if(cs != null) cs = cs.getRootCoordSyst();
    v.setCoordSyst(cs);
    v.setCoordSyst(se.getCenter().getCoordSyst());
    se.getCenter().addVector(v);
    p.move(position);
  }
  
  public void update() {
    CoordSyst cs = se.getCenter().getCoordSyst();
    if(cs != null) cs = cs.getRootCoordSyst();
    Position p2 = se.getCenter().clone(cs);
    p2.setCoordSyst(null);
    p.move(p2);
    //p.move(se.getCenter());
    move(p);
  }
  
  private PropertyChangeListener moveListener = new PropertyChangeListener() {
    public void propertyChange(PropertyChangeEvent e) {
      if(e instanceof MoveEvent) update();
    }
  };
}
