/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.util.*;
import java.beans.*;

/**
 * @author Artiste on the Web
 */

public class FragmentedShapeBeanInfo extends AbstractBeanInfo {
  public FragmentedShapeBeanInfo() {
    super(true, false, false); 

    PropertyDescriptor[] pd = new PropertyDescriptor[4];
    try {
      pd[0] = new PropertyDescriptor("visibility", getBeanClass(), null, "setVisibility");
      pd[0].setPropertyEditorClass(opale.soya.soya3d.model.VisibilityPropertyEditor.class);
      pd[1] = new PropertyDescriptor("smoothLit", getBeanClass(), null, "setSmoothLit");
      pd[2] = new PropertyDescriptor("material", getBeanClass(), null, "setMaterial");
      pd[2].setPropertyEditorClass(opale.soya.soya2d.MaterialEditorWriteOnly.class);
      //pd[2] = new PropertyDescriptor("staticLit", getBeanClass(), null, "setStaticLit");
      //pd[2].setHidden(true);
      pd[3] = new PropertyDescriptor("elementsCreated", getBeanClass(), "isElementsCreated", null);
      pd[3].setHidden(true);
    }
    catch(Exception e) {
      System.out.println(getClass().getName() + " : error");
      e.printStackTrace();
    }
    addPropertyDescriptors(pd);
  }
  
  public BeanDescriptor getBeanDescriptor() {
    return new BeanDescriptor(opale.soya.soya3d.model.FragmentedShape.class, opale.soya.soya3d.model.FragmentedShapeCustomizer.class);
  }
}
