/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import gl4java.*;
import java.io.*;
import java.beans.*;

/*
 * @author Artiste on the web
 */

public class FragmentFromElement extends Object implements Fragment, CoordSyst {
  public FragmentFromElement() { super(); }
  public FragmentFromElement(FragmentElement3D g) {
    super();
    e = g;
  }
  
  public static Fragment[] fragmentsFromShapeElements(Shape newShape, FragmentedShapeElement[] ses) {
    Fragment[] fs = new Fragment[ses.length];
    for(int i = 0; i < ses.length; i++) {
      fs[i] = ((FragmentElement3D) ses[i]).getFragment();
      fs[i].setShape(newShape);
    }
    return fs;
  }
  
  private FragmentElement3D e;
  public FragmentElement3D getElement() { return e; }
  public void setElement(FragmentElement3D g) { e = g; }
  
  /** Not supported */
  public Material getMaterial() { return null; }
  /** Not supported */
  public boolean  getUseAlpha() { return false; }
  
  public boolean canCombineWith(Fragment f) { return false; }
  public Fragment combineWith(Fragment f) { return this; }
  
  public int getNumberOfShapeElements() { return 1; }
  public FragmentedShapeElement[] getFragmentedShapeElements() {
    FragmentedShapeElement[] fse = { (FragmentedShapeElement) e };
    return fse;
  }
  
  public void reBuild() {  }
  
  public void fillCollector(DrawablesCollector f, Renderer r, float[] mat) {
    if(e instanceof DrawablesCollectorFiller) {
      mat = Matrix.matrixMultiply(mat, preMatrix);
      ((DrawablesCollectorFiller) e).fillCollector(f, r, mat);
    }
  }
  public void draw(Renderer r, GLFunc gl, GLUFunc glu) {
    if(e instanceof Drawable) ((Drawable) e).draw(r, gl, glu);
  }
  public void draw(Renderer r, GLFunc gl, GLUFunc glu, SpecialEffect[] specialEffects) {
    if(e instanceof Drawable) {
      for(int i = 0; i < specialEffects.length; i++) specialEffects[i].  makeCurrent(gl, glu);
      ((Drawable) e).draw(r, gl, glu);
      for(int i = 0; i < specialEffects.length; i++) specialEffects[i].unmakeCurrent(gl, glu);
    }
  }
  
  // PreTransformable :
  private final float[] preMatrix = Matrix.matrixIdentity();
  /**
   * Gets the matrix that contains all the pre-transformation. Null if this fragment element
   * is not used as a fragment.
   * @return the pre matrix
   */
  public float[] getPreMatrix() { return preMatrix; }
  /**
   * Pre transforms this fragment element.
   * Warning : This method can be used only if this object is used as a fragment.
   * @param mat the transformation matrix
   */
  public void preTransform(float[] mat) {
    invalidatePreBuiltMatrixes();
    System.arraycopy(Matrix.matrixMultiply(mat, preMatrix), 0, preMatrix, 0, 16);
    leftHanded = (preMatrix[0] * preMatrix[5] * preMatrix[10] < 0f);
    e.fireAnimationChange();
  }
  
  
  private Shape shape;
  public void setShape(Shape newShape) { shape = newShape; }
  
  public Object clone() {
    return new FragmentFromElement((FragmentElement3D) e.clone());
  }
  
  public Fragment getOptimizedFragment() { return this; }
  
  // Bean :
  public java.util.Collection propertyChangeListeners() { return null; }
  public void addPropertyChangeListener   (PropertyChangeListener l) {  }
  public void removePropertyChangeListener(PropertyChangeListener l) {  }
  public void firePropertyChange() {  }
  public void firePropertyChange(String propertyName) {  }
  public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {  }

  // CoordSyst :
  public CoordSyst getRootCoordSyst() { return shape; }
  public CoordSyst getCoordSyst() { return shape; }
  private float[] invertedPreMatrix;
  public float[] getMatrix() { return preMatrix; }
  public float[] getRootMatrix() { return (float[]) preMatrix.clone(); }
  public float[] getInvertedRootMatrix() {
    buildInvertedPreMatrix();
    return (float[]) invertedPreMatrix.clone();
  }
  protected void buildInvertedPreMatrix() {
    if(invertedPreMatrix != null) return;
    invertedPreMatrix = Matrix.matrixInvert(preMatrix);
  }
  protected void invalidatePreBuiltMatrixes() {
    invertedPreMatrix = null;
  }
  public void convertPointTo(float[] p) { // Optimizable
    buildInvertedPreMatrix();
    System.arraycopy(Matrix.pointMultiplyByMatrix(invertedPreMatrix, p), 0, p, 0, 3);
  }
  public void convertPointFrom(float[] p) { // Optimizable
    System.arraycopy(Matrix.pointMultiplyByMatrix(preMatrix, p), 0, p, 0, 3);
  }
  public void convertVectorTo(float[] p) { // Optimizable
    buildInvertedPreMatrix();
    System.arraycopy(Matrix.vectorMultiplyByMatrix(invertedPreMatrix, p), 0, p, 0, 3);
  }
  public void convertVectorFrom(float[] p) { // Optimizable
    System.arraycopy(Matrix.vectorMultiplyByMatrix(preMatrix, p), 0, p, 0, 3);
  }
  public void printMatrix() {
    buildInvertedPreMatrix();
    System.out.println("pre matrix : " + Matrix.matrixToString(preMatrix));
    System.out.println("inverted pre matrix : " + Matrix.matrixToString(invertedPreMatrix));
  }
  public void printRealMatrix() {
    invalidatePreBuiltMatrixes();
    buildInvertedPreMatrix();
    System.out.println("pre matrix : " + Matrix.matrixToString(preMatrix));
    System.out.println("inverted pre matrix : " + Matrix.matrixToString(invertedPreMatrix));
  }
  public Vector x () { return new Vector(1f, 0f, 0f, this); }
  public Vector y () { return new Vector(0f, 1f, 0f, this); }
  public Vector z () { return new Vector(0f, 0f, 1f, this); }
  public Position origin () { return new Point(0f, 0f, 0f, this); }
  public boolean leftHanded;
  public boolean isLeftHanded () { return  leftHanded; }
  public boolean isRightHanded() { return !leftHanded; }
  
  // Dimension :
  public DimensionWrapper wrapper() { return e.wrapper(); }
  
  public float getWidth () { return e.getWidth (); }
  public float getHeight() { return e.getHeight(); }
  public float getDepth () { return e.getDepth (); }
  public void setWidth (float f) { e.setWidth (f); }
  public void setHeight(float f) { e.setHeight(f); }
  public void setDepth (float f) { e.setDepth (f); }
  
  //public float[] getDims() { return e.getDims(); }
  public void setDims(float w, float h, float d) { e.setDims(w, h, d); }
  
  //public float[] getFactors() { return e.getFactors(); }
  public float getXFactor() { return e.getXFactor(); }
  public float getYFactor() { return e.getYFactor(); }
  public float getZFactor() { return e.getZFactor(); }
  public void setXFactor(float f) { e.setXFactor(f); }
  public void setYFactor(float f) { e.setYFactor(f); }
  public void setZFactor(float f) { e.setZFactor(f); }
  
  public void scale(float f) { preTransform(Matrix.matrixScale(f, f, f)); }
  public void scale(float x, float y, float z) { preTransform(Matrix.matrixScale(x, y, z)); }
  
  // No events required for fragments.
  public void fireResize() {  }
  public void fireResize(String propertyName) {  }
  public void fireResize(String propertyName, Object oldValue, Object newValue) {  }
  
  public String toString() {
    return "FragmentFromElement {\n" + "Element :\n" + e.toString() + "\n}";
  }
}
