/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Library Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.util.*;
import java.beans.*;

/**
 * @author Artiste on the Web
 */

public class FaceBeanInfo extends AbstractBeanInfo {
  public FaceBeanInfo() {
    super(true, false, false);

    PropertyDescriptor[] pd = new PropertyDescriptor[12];
    try {
      pd[ 0] = new PropertyDescriptor("visibility", getBeanClass());
      pd[ 0].setPropertyEditorClass(opale.soya.soya3d.model.VisibilityPropertyEditor.class);
      pd[ 1] = new PropertyDescriptor("material", getBeanClass());
      pd[ 2] = new PropertyDescriptor("normal", getBeanClass(), "getNormal", null);
      pd[ 2].setHidden(true);
      pd[ 3] = new PropertyDescriptor("numberOfPoints", getBeanClass(), "getNumberOfPoints", null);
      pd[ 3].setHidden(true);
      pd[ 4] = new PropertyDescriptor("points", getBeanClass());
      pd[ 4].setHidden(true);
      pd[ 5] = new PropertyDescriptor("useAlpha", getBeanClass(), "getUseAlpha", null);
      pd[ 5].setHidden(true);
      pd[ 6] = new PropertyDescriptor("useColor", getBeanClass(), "getUseColor", null);
      pd[ 6].setHidden(true);
      pd[ 7] = new PropertyDescriptor("hidden", getBeanClass());
      pd[ 8] = new PropertyDescriptor("red"  , getBeanClass(), null, "setRed"  );
      pd[ 9] = new PropertyDescriptor("green", getBeanClass(), null, "setGreen");
      pd[10] = new PropertyDescriptor("blue" , getBeanClass(), null, "setBlue" );
      pd[11] = new PropertyDescriptor("alpha", getBeanClass(), null, "setAlpha");
    }
    catch(Exception e) {
      System.out.println(getClass().getName() + " : error");
      e.printStackTrace();
    }
    addPropertyDescriptors(pd);
  }
}
