/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import gl4java.*;
import java.io.*;

/**
 * Interface for any object that can be drawn.
 * 
 * @author Artiste on the web
 */

public interface Drawable extends DrawablesCollectorFiller {
  /**
   * Gets this fragment's material. A fragment can use only a single material.
   * @return the material
   */
  public Material getMaterial();
  /**
   * Checks if this fragment uses alpha. If true, it will be drawn after all the non alpha
   * user fragments, and with OpenGL alpha blending enabled.
   * @return true if use alpha
   */
  public boolean getUseAlpha();
  /**
   * Draw this fragment.
   * @param r the renderer
   * @param gl  the gl
   * @param glu the glu
   */
  public void draw(Renderer r, GLFunc gl, GLUFunc glu);
  public void draw(Renderer r, GLFunc gl, GLUFunc glu, SpecialEffect[] specialEffects);
}
