/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.geometry;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import gl4java.*;
import java.beans.*;
import java.io.*;

/**
 * A Sphere is a spheric fragment / element.
 * You can change its size through the Dimension interface, the radius is 1f always.
 * You can also choose the face visibility.
 *
 * @author Artiste on the Web
 */
public class Sphere3D extends FixedFragmentElement3D implements FaceVisibility {
  /**
   * Create a sphere.
   */
  public Sphere3D() { super(); }
  /**
   * Create a sphere with the given name.
   * @param name the name
   */
  public Sphere3D(String name) { super(name); }
  
  /**
   * Clones this sphere.
   * @return the clone
   */
  public Object clone() {
    Sphere3D o = (Sphere3D) super.clone();
    o.slices = slices;
    o.stacks = stacks;
    o.visibility = visibility;
    o.setMaterial(material);
    return o;
  }
  
  /*
  public static Fragment[] fragmentsFromShapeElements(Shape newShape, FragmentedShapeElement[] ses) {
    return FixedFragmentElement3D.fragmentsFromShapeElements(newShape, ses);
  }
  */
  
  // A few properties.
  private int slices = 10, stacks = 10;
  /**
   * gets the number of slices.
   * @return the number of slices
   */
  public int getSlices() { return slices; }
  /**
   * sets the number of slices.
   * @param i the new number of slices
   */
  public void setSlices(int i) {
    slices = i;
    reBuild(); // Rebuild the call list : update the Element.
    firePropertyChange("slices"); // Raise an event.
  }
  /**
   * gets the number of stacks.
   * @return the number of stacks
   */
  public int getStacks() { return stacks; }
  /**
   * sets the number of stacks.
   * @param i the new number of stacks
   */
  public void setStacks(int i) {
    stacks = i;
    reBuild();
    firePropertyChange("stacks");
  }

  private int visibility = FaceVisibility.VISIBILITY_EXTERIOR;
  public int getVisibility() { return visibility; }
  public void setVisibility(int i) {
    visibility = i;
    reBuild();
    firePropertyChange("visibility");
  }
  
  private transient Material material = Material.WHITE_MATERIAL;
  public Material getMaterial() { return material; }
  public void setMaterial(Material m) {
    material = m;
    reBuild();
    firePropertyChange("material");
  }
  
  public float getNaturalWidth () { return 2f; }
  public float getNaturalHeight() { return 2f; }
  public float getNaturalDepth () { return 2f; }
  public DimensionWrapper wrapper() {
    return new Box(new Point(-1f, -1f, -1f, this), new Point(1f, 1f, 1f, this));
  }
  
  /**
   * draw the fragment, using the given gl and glu.
   * @param gl  the gl
   * @param glu the gl
   */
  public void fixedDraw(GLFunc gl, GLUFunc glu) { // Draw the sphere with the glu function.
    int id = glu.gluNewQuadric();
    if(material.isWireframed()) glu.gluQuadricDrawStyle(id, GLUEnum.GLU_LINE);
    switch(visibility) {
    case VISIBILITY_EXTERIOR: glu.gluQuadricOrientation(id, GLUEnum.GLU_OUTSIDE); break;
    case VISIBILITY_INTERIOR: glu.gluQuadricOrientation(id, GLUEnum.GLU_INSIDE ); break;
    }
    glu.gluQuadricNormals(id, GLUEnum.GLU_SMOOTH);
    if(getMaterial().getTexture() != null) glu.gluQuadricTexture(id, GLEnum.GL_TRUE);
    glu.gluSphere(id, 1f, slices, stacks);
    glu.gluDeleteQuadric(id);
  }
  
  private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
    s.defaultReadObject();
    material = Material.read(s);
  }
  private void writeObject(ObjectOutputStream s) throws IOException {
    s.defaultWriteObject();
    material.write(s);
  }
}
