/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.fx.particle;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import gl4java.*;
import java.io.*;
import java.beans.*;

/**
 * A particles drawer that draws particles as points.
 *
 * @author Artiste on the Web
 */

public class PointParticlesDrawer extends ParticlesDrawer {
  /**
   * Create a points particles drawer.
   */
  public PointParticlesDrawer() {
    super();
    size = 1f;
  }
  /**
   * Create a points particles drawer.
   * @param s the point size
   */
  public PointParticlesDrawer(float s) {
    super();
    size = s;
  }
  
  /**
   * Clones this particles drawer.
   * @return the clone
   */
  public Object clone() {
    PointParticlesDrawer o = (PointParticlesDrawer) super.clone();
    o.size = size;
    
    return o;
  }
  
  private static final float[] factors0 = { 0f, 1f, 0f };
  private static final float[] factors1 = { 1f, 0f, 0f };
  // Overrides :
  protected void drawBunch(Renderer r, GLFunc gl, GLUFunc glu) {
    gl.glDisable(GLEnum.GL_LIGHTING);
    gl.glEnable (GLEnum.GL_COLOR_MATERIAL);
    bunch.colors.makeColorCurrent(gl, glu);
    
    gl.glEnableClientState(GLEnum.GL_VERTEX_ARRAY);
    gl.glVertexPointer(3, GLEnum.GL_FLOAT, 0, bunch.positions);
    if(bunch.colors.canUseArray()) {
      gl.glEnableClientState(GLEnum.GL_COLOR_ARRAY);
      bunch.colors.defineArray(gl, glu);
    }
    else gl.glDisableClientState(GLEnum.GL_COLOR_ARRAY);
    gl.glDisableClientState(GLEnum.GL_NORMAL_ARRAY       );
    gl.glDisableClientState(GLEnum.GL_TEXTURE_COORD_ARRAY);
    
    gl.glPointSize(size);
    gl.glPointParameterfvEXT(GLEnum.GL_DISTANCE_ATTENUATION_EXT, factors1);
    
    //gl.glDrawArrays(GLEnum.GL_POINTS, 0, nbParticles);
    gl.glBegin(GLEnum.GL_POINTS);
    if(bunch.colors.canUseArray()) {
      for(int i = 0; i < nbParticles; i++) {
        if(bunch.lifes.lifes[i] > 0f) gl.glArrayElement(i);
      }
    }
    else {
      for(int i = 0; i < nbParticles; i++) {
        if(bunch.lifes.lifes[i] > 0f) {
          bunch.colors.makeParticleColorCurrent(gl, glu, i);
          gl.glArrayElement(i);
        }
      }
    }
    gl.glEnd();
    
    gl.glEnable (GLEnum.GL_LIGHTING);
    gl.glDisable(GLEnum.GL_COLOR_MATERIAL);
    gl.glPointParameterfvEXT(GLEnum.GL_DISTANCE_ATTENUATION_EXT, factors0);
  }
  
  // Particles properties :
  
  // A few properties.
  protected float size;
  /**
   * Gets the points' size.
   * Default is 1f.
   * @return the points' size
   */
  public float getSize() { return size; }
  /**
   * Sets the points' size.
   * @param f the new points' size
   */
  public void setSize(float f) {
    size = f;
    firePropertyChange("size");
  }
}
