/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.fx.particle;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import gl4java.*;
import java.io.*;
import java.beans.*;

/**
 * An interface for all object that has particles' stuff.
 *
 * @author Artiste on the Web
 */

public interface ParticlesStuff {
  /**
   * Advances the particle of the given ID.
   * @param id the particle ID
   * @param factor the fps factor
   */
  public void advanceParticle(int id, float factor);
  /**
   * Inits the particle of the given ID.
   * @param id the particle ID
   */
  public void initParticle   (int id);
  /**
   * Deletes the particle of the given ID.
   * @param id the particle ID
   */
  public void deleteParticle (int id);
  
  /**
   * Gets the number of particles in this particles stuff.
   * @return the number of particles
   */
  public int getNumberOfParticles();
  /**
   * Sets the number of particles in this particles stuff.
   * @param nb the new number of particles
   */
  public void setNumberOfParticles(int nb);
  
  /**
   * Gets the particles bunch that uses this particles stuff.
   * @return the particles bunch
   */
  public ParticlesBunch3D getBunch();
}
