/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.fx.particle;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import gl4java.*;
import java.io.*;
import java.beans.*;

/**
 * An object that draws particles.
 *
 * @author Artiste on the Web
 */

public abstract class ParticlesDrawer extends AbstractBean implements ParticlesStuff, DrawablesCollectorFiller {
  private static final long serialVersionUID = -3753200479959815069l;
  /**
   * Create a particles drawer.
   */
  public ParticlesDrawer() { super(); }
  
  /**
   * Clones this particles drawer.
   * @return the clone
   */
  public Object clone() {
    ParticlesDrawer o = null;
    try { o = (ParticlesDrawer) getClass().newInstance(); }
    catch(Exception e) { System.out.println("Cannot clone !"); e.printStackTrace(); }
    
    return o;
  }
  
  protected ParticlesBunch3D bunch;
  public ParticlesBunch3D getBunch() { return bunch; }
  
  public void initParticle(int id) {
  }
  public void advanceParticle(int id, float factor) {
  }
  public void deleteParticle(int id) {
  }
  
  public void fillCollector(DrawablesCollector f, Renderer r, float[] mat) { // Optimizable
    f.collect(bunch, mat);
  }
  /**
   * Draws the bunch of particles.
   * @param r the renderer
   * @param gl the gl
   * @param glu the glu
   */
  protected abstract void drawBunch(Renderer r, GLFunc gl, GLUFunc glu);
  
  // Particles properties :
  
  // A few properties.
  protected int nbParticles;
  public int getNumberOfParticles() { return nbParticles; }
  public void setNumberOfParticles(int i) {
    nbParticles = i;
    firePropertyChange("numberOfParticles");
  }
  
  public Material getMaterial() { return Material.WHITE_MATERIAL; }
  public boolean getUseAlpha() { return false; }
}
