/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.fx.particle;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import gl4java.*;
import java.io.*;
import java.beans.*;

/**
 * A sprite particles drawer that draws particles as several sprites (one at the current particle's position, and the other at its previous positions).
 *
 * @author Artiste on the Web
 */

public class MultipleSpriteParticlesDrawer extends SpriteParticlesDrawer {
  private static final long serialVersionUID = -407006984161228544l;
  /**
   * Create a sprites particles drawer.
   */
  public MultipleSpriteParticlesDrawer() {
    super();
  }
  /**
   * Create a sprites particles drawer.
   * @param m the sprite's material
   */
  public MultipleSpriteParticlesDrawer(Material m, int nb) {
    super(m);
    setNumberOfSpritesPerParticle(nb);
  }
  /**
   * Create a particles drawer.
   * @param m the sprite's material
   * @param x1 x1
   * @param y1 y1
   * @param x2 x2
   * @param y2 y2
   */
  public MultipleSpriteParticlesDrawer(Material m, float x1, float y1, float x2, float y2, int nb) {
    super(m, x1, y1, x2, y2);
    setNumberOfSpritesPerParticle(nb);
  }
  
  /**
   * Clones this particles drawer.
   * @return the clone
   */
  public Object clone() {
    MultipleSpriteParticlesDrawer o = (MultipleSpriteParticlesDrawer) super.clone();
    o.setNumberOfSpritesPerParticle(nb);
    
    return o;
  }
  
  // Overrides :
  protected void drawBunch(Renderer r, GLFunc gl, GLUFunc glu) {
    gl.glDisable(GLEnum.GL_LIGHTING);
    gl.glEnable (GLEnum.GL_COLOR_MATERIAL);
    gl.glDisable(GLEnum.GL_CULL_FACE);
    bunch.colors.makeColorCurrent(gl, glu);
    
    float x0, y0, z0;
    float x , y , z ;
    
    gl.glBegin(GLEnum.GL_QUADS);
    for(int i = 0; i < nbParticles; i++) {
      if(bunch.lifes.lifes[i] > 0f) {
        x0 = bunch.positions[i * 3    ];
        y0 = bunch.positions[i * 3 + 1];
        z0 = bunch.positions[i * 3 + 2];
        x  = x0 * matrix0[0] + y0 * matrix0[4] + z0 * matrix0[ 8];
        y  = x0 * matrix0[1] + y0 * matrix0[5] + z0 * matrix0[ 9];
        z  = x0 * matrix0[2] + y0 * matrix0[6] + z0 * matrix0[10];
        bunch.colors.makeParticleColorCurrent(gl, glu, i);
        gl.glTexCoord2f(0f, 0f); gl.glVertex3f(x + x1, y + y1, z);
        gl.glTexCoord2f(1f, 0f); gl.glVertex3f(x + x2, y + y1, z);
        gl.glTexCoord2f(1f, 1f); gl.glVertex3f(x + x2, y + y2, z);
        gl.glTexCoord2f(0f, 1f); gl.glVertex3f(x + x1, y + y2, z);
      }
    }
    gl.glEnd();
    for(int j = 0; j < oldPositions.length; j++) {
      colors[j].makeColorCurrent(gl, glu);
      gl.glBegin(GLEnum.GL_QUADS);
      for(int i = 0; i < nbParticles; i++) {
        if(bunch.lifes.lifes[i] > 0f) {
          x0 = oldPositions[j][i * 3    ];
          y0 = oldPositions[j][i * 3 + 1];
          z0 = oldPositions[j][i * 3 + 2];
          x  = x0 * matrix0[0] + y0 * matrix0[4] + z0 * matrix0[ 8];
          y  = x0 * matrix0[1] + y0 * matrix0[5] + z0 * matrix0[ 9];
          z  = x0 * matrix0[2] + y0 * matrix0[6] + z0 * matrix0[10];
          colors[j].makeParticleColorCurrent(gl, glu, i);
          gl.glTexCoord2f(0f, 0f); gl.glVertex3f(x + x1, y + y1, z);
          gl.glTexCoord2f(1f, 0f); gl.glVertex3f(x + x2, y + y1, z);
          gl.glTexCoord2f(1f, 1f); gl.glVertex3f(x + x2, y + y2, z);
          gl.glTexCoord2f(0f, 1f); gl.glVertex3f(x + x1, y + y2, z);
        }
      }
      gl.glEnd();
    }
    
    
    gl.glEnable (GLEnum.GL_LIGHTING);
    gl.glEnable (GLEnum.GL_CULL_FACE);
    gl.glDisable(GLEnum.GL_COLOR_MATERIAL);
    material.makeColorCurrent(gl, glu);
    
    for(int i = nb - 2; i > 0; i--) {
      System.arraycopy(oldPositions[i - 1], 0, oldPositions[i], 0, 3 * nbParticles);
    }
    System.arraycopy(bunch.positions, 0, oldPositions[0], 0, 3 * nbParticles);
  }
  
  // Particles properties :
  protected float[][] oldPositions;
  
  // Drawer properties :
  protected int nb = 2;
  public int getNumberOfSpritesPerParticle() { return nb; }
  public void setNumberOfSpritesPerParticle(int i) {
    if(nb == i) return;
    nb = i;
    
    oldPositions = new float[nb - 1][];
    for(int j = 0; j < oldPositions.length; j++) oldPositions[j] = new float[3 * nbParticles];
    /*
    for(int j = 0; j < oldPositions.length; j++) {
      System.out.println("oldPosition.length : ");
      System.out.println(j + " : " + oldPosition[j].length);
    }
    */
    
    if(colors != null) {
      ParticlesColors[] colors2 = colors;
      colors = new ParticlesColors[nb - 1];
      if(colors.length > colors2.length) System.arraycopy(colors, 0, colors2, 0, colors2.length);
      else                               System.arraycopy(colors, 0, colors2, 0, colors .length);
    }
    else colors = new ParticlesColors[nb - 1];
    
    firePropertyChange("numberOfSpritesPerParticle");
  }
  public void setNumberOfParticles(int nb) {
    if(colors != null) {
      for(int i = 0; i < colors.length; i++) {
        if(colors[i] != null) colors[i].setNumberOfParticles(nb);
      }
    }
    
    if(oldPositions != null) {
      for(int j = 0; j < oldPositions.length; j++) oldPositions[j] = new float[3 * nb];
    }
    
    super.setNumberOfParticles(nb);
  }
  
  protected ParticlesColors[] colors;
  public void buildFadingColors(float alphaFactor) {
    float alpha;
    if(bunch.colors instanceof MultipleParticlesColors) {
      alpha = 1f;
      for(int i = 0; i < colors.length; i++) {
        alpha = alpha * alphaFactor;
        colors[i] = new ParticlesColorsWrapper((MultipleParticlesColors) bunch.colors, alpha);
      }
    }
    else {
      alpha = bunch.colors.getAlpha();
      for(int i = 0; i < colors.length; i++) {
        alpha = alpha * alphaFactor;
        colors[i] = (ParticlesColors) bunch.colors.clone();
        colors[i].setAlpha(alpha);
      }
    }
  }
  public void initParticle(int id) {
    super.initParticle(id);
    for(int i = 0; i < colors.length; i++) colors[i].initParticle(id);
  }
  public void advanceParticle(int id, float factor) {
    super.advanceParticle(id, factor);
    for(int i = 0; i < colors.length; i++) colors[i].advanceParticle(id, factor);
  }
  public void deleteParticle(int id) {
    super.deleteParticle(id);
    for(int i = 0; i < colors.length; i++) colors[i].deleteParticle(id);
  }
  
  protected class ParticlesColorsWrapper extends ParticlesColors {
    private static final long serialVersionUID = 7503082393533388013l;
    public ParticlesColorsWrapper(MultipleParticlesColors c, float a) {
      super();
      colors = c;
      alpha  = a;
      this.setNumberOfParticles(colors.getNumberOfParticles());
    }
    
    public Object clone() {
      MultipleParticlesColors o = (MultipleParticlesColors) super.clone();
      
      return o;
    }
    
    protected MultipleParticlesColors colors;
    protected float alpha;
    
    public void initParticle(int id)                  {  }
    public void advanceParticle(int id, float factor) {  }
    public void deleteParticle(int id)                {  }
    
    public boolean canUseArray() { return false; }
    public void defineArray(GLFunc gl, GLUFunc glu) {
      //gl.glColorPointer (4, GLEnum.GL_FLOAT, 0, colors);
    }
    
    public void makeColorCurrent(GLFunc gl, GLUFunc glu) {  }
    public void makeParticleColorCurrent(GLFunc gl, GLUFunc glu, int id) {
      gl.glColor4f(colors.colors[id * 4], colors.colors[id * 4 + 1], colors.colors[id * 4 + 2], colors.colors[id * 4 + 3] * alpha);
    }
  }
}
