/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.fx.particle;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import gl4java.*;
import java.io.*;
import java.beans.*;

/**
 * A particles' colors with different colors for each particles.
 * 
 * @author Artiste on the Web
 */

public abstract class MultipleParticlesColors extends ParticlesColors {
  private static final long serialVersionUID = 7503082393533388013l;
  /**
   * Create a particles colors.
   */
  public MultipleParticlesColors() { super(); }
  /**
   * Create a particles colors.
   * @param r the red color component
   * @param g the green color component
   * @param b the blue color component
   * @param a the alpha color component
   */
  public MultipleParticlesColors(float r, float g, float b, float a) {
    super(r, g, b, a);
  }
  
  /**
   * Clones this particles colors.
   * @return the clone
   */
  public Object clone() {
    MultipleParticlesColors o = (MultipleParticlesColors) super.clone();
    
    return o;
  }
  
  public void initParticle(int id) {
    id = id * 4;
    colors[id    ] = color[0];
    colors[id + 1] = color[1];
    colors[id + 2] = color[2];
    colors[id + 3] = color[3];
  }
  public void advanceParticle(int id, float factor) {
  }
  public void deleteParticle(int id) {
  }
  
  public boolean canUseArray() { return true; }
  public void defineArray(GLFunc gl, GLUFunc glu) { gl.glColorPointer (4, GLEnum.GL_FLOAT, 0, colors); }
  
  public void makeColorCurrent(GLFunc gl, GLUFunc glu) {
  }
  public void makeParticleColorCurrent(GLFunc gl, GLUFunc glu, int id) {
    gl.glColor4f(colors[id * 4], colors[id * 4 + 1], colors[id * 4 + 2], colors[id * 4 + 3]);
  }
  
  // Particles properties :
  protected float[] colors;
  
  // A few properties.
  // Overrides :
  public void setNumberOfParticles(int i) {
    if(colors == null) colors = new float[i * 4];
    else {
      float[] colors2 = new float[i * 4];
      if(nbParticles < i)
        System.arraycopy(colors, 0, colors2, 0, nbParticles * 4);
      else
        System.arraycopy(colors, 0, colors2, 0, i * 4);
      colors = colors2;
    }
    super.setNumberOfParticles(i);
  }
}
