/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.fx.particle;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import opale.soya.soya3d.fx.*;
import gl4java.*;
import java.io.*;
import java.beans.*;

/**
 * A bunch of particles that move.
 * 
 * This object manages particles' speeds, and extends particle bunch, that manages particles'
 * positions.
 * 
 * @author Artiste on the Web
 */

public abstract class MovingParticlesBunch3D extends ParticlesBunch3D /* implements */ {
  private static final long serialVersionUID = 3720849687663320809l;
  /**
   * Create a moving particles bunch.
   */
  public MovingParticlesBunch3D() { super(); }
  /**
   * Create a moving particles bunch.
   * @param l the object that manages the particles' lifes
   * @param c the object that manages the particles' colors
   * @param d the object that draws the particles
   */
  public MovingParticlesBunch3D(ParticlesLifes l, ParticlesColors c, ParticlesDrawer d) { super(l, c, d); }
  
  /**
   * Clones this moving particles bunch.
   * @return the clone
   */
  public Object clone() {
    MovingParticlesBunch3D o = (MovingParticlesBunch3D) super.clone();
    
    return o;
  }
  
  
  public void initParticle(int id) {
    super.initParticle(id);
  }
  /**
   * Inits the speed of the particle of the given ID.
   * @param id the particle ID
   * @param speed the new particle speed
   */
  protected void initParticleSpeed(int id, Vector speed) {
    if((speed.getCoordSyst() != this) && (speed.getCoordSyst() != null)) speed = (Vector) speed.clone(this);
    speeds[id * 3    ] = speed.getX();
    speeds[id * 3 + 1] = speed.getY();
    speeds[id * 3 + 2] = speed.getZ();
  }
  /**
   * Inits the speed of the particle of the given ID.
   * @param id the particle ID
   * @param x the new particle x speed
   * @param y the new particle y speed
   * @param z the new particle z speed
   */
  protected void initParticleSpeed(int id, float x, float y, float z) {
    id = id * 3;
    if(coordSyst == this) {
      speeds[id    ] = x;
      speeds[id + 1] = y;
      speeds[id + 2] = z;
    }
    else {
      if(coordSyst == null) {
        float[] m = getRootMatrix();
        speeds[id    ] = x * m[0] + y * m[4] + z * m[ 8];
        speeds[id + 1] = x * m[1] + y * m[5] + z * m[ 9];
        speeds[id + 2] = x * m[2] + y * m[6] + z * m[10];
      }
      else {
        Position p = new Point(x, y, z, this);
        p.setCoordSyst(coordSyst);
        speeds[id    ] = p.getX();
        speeds[id + 1] = p.getY();
        speeds[id + 2] = p.getZ();
      }
    }
  }
  public void advanceParticle(int id, float factor) {
    super.advanceParticle(id, factor);
    positions[id * 3    ] = positions[id * 3    ] + factor * speeds[id * 3    ];
    positions[id * 3 + 1] = positions[id * 3 + 1] + factor * speeds[id * 3 + 1];
    positions[id * 3 + 2] = positions[id * 3 + 2] + factor * speeds[id * 3 + 2];
  }
  public void deleteParticle(int id) {
    super.deleteParticle(id);
  }
  
  // Particles properties :
  protected float[] speeds;
  
  // A few properties.
  public void setNumberOfParticles(int i) {
    if(speeds == null) {
      speeds = new float[3 * i];
    }
    else {
      float[] speeds2 = new float[3 * i];
      if(nbParticles < i)
        System.arraycopy(speeds, 0, speeds2, 0, 3 * nbParticles);
      else
        System.arraycopy(speeds, 0, speeds2, 0, 3 * i);
      speeds = speeds2;
    }
    super.setNumberOfParticles(i);
  }
}
