/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.fx.particle;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import opale.soya.soya3d.fx.*;
import gl4java.*;
import java.io.*;
import java.beans.*;

/**
 * A bunch of fixed particles. The particles are created randomly around a given point.
 * 
 * @author Artiste on the Web
 */

public class Halo3D extends ParticlesBunch3D /* implements */ {
  private static final long serialVersionUID = 8545499030019472717l;
  /**
   * Create particles.
   */
  public Halo3D() {
    super();
  }
  /**
   * Create particles.
   * @param l the object that manages the particles' lifes
   * @param c the object that manages the particles' colors
   * @param d the object that draws the particles
   */
  public Halo3D(ParticlesLifes l, ParticlesColors c, ParticlesDrawer d) {
    super(l, c, d);
  }
  
  /**
   * Clones this particles bunch.
   * @return the clone
   */
  public Object clone() {
    Halo3D o = (Halo3D) super.clone();
    
    return o;
  }
  
  public void initParticle(int id) {
    super.initParticle(id);
    
    if(radius == 0f) 
      initParticlePosition(id, 0f, 0f, 0f);
    else {
      Vector v = new Vector(((float) Math.random()) - .5f,((float) Math.random()) - .5f, ((float) Math.random()) - .5f);
      v.scale(radius / v.length());
      initParticlePosition(id, v.getX(), v.getY(), v.getZ());
    }
    
    
    /*
    if(last != null) {
      float h = (float) Math.random();
      id = id * 3;
      positions[id    ] = h * last.getX() + (1 - h) * current.getX();
      positions[id + 1] = h * last.getY() + (1 - h) * current.getY();
      positions[id + 2] = h * last.getZ() + (1 - h) * current.getZ();
    }
    else {
      initParticlePosition(id, 0f, 0f, 0f);
    }
    */
  }
  
  
  protected transient Position current, last;
  public void advanceBunch(float factor) {
    super.advanceBunch(factor);
    
    last = current;
    if(coordSyst == null) current = clone(getRootParent());
    else                  current = clone(coordSyst      );
  }
  
  // Particles properties :
  
  // Bunch properties :
  protected float radius = 1f;
  /**
   * Gets the radius of the halo.
   * Default is 1f.
   * @return the radius
   */
  public float getRadius() { return radius; }
  /**
   * Sets the radius of the halo.
   * @param f the radius
   */
  public void setRadius(float f) {
    radius = f;
    firePropertyChange("radius");
  }
}
