/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.fx.particle;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import gl4java.*;
import java.io.*;
import java.beans.*;

/**
 * A multiple particles' colors with colors that change from a color to another.
 * 
 * @author Artiste on the Web
 */

public class ChangingParticlesColors extends MultipleParticlesColors {
  /**
   * Create a changing particles colors.
   */
  public ChangingParticlesColors() { super(); }
  /**
   * Create a particles colors.
   * @param r the red color component
   * @param g the green color component
   * @param b the blue color component
   * @param a the alpha color component
   */
  public ChangingParticlesColors(float r, float g, float b, float a) {
    super(r, g, b, a);
  }
  /**
   * Create a particles colors.
   * @param r the red color component of the initial and final colors
   * @param g the green color component of the initial and final colors
   * @param b the blue color component of the initial and final colors
   * @param a the alpha color component of the initial color
   * @param a2 the alpha color component of the final color
   */
  public ChangingParticlesColors(float r, float g, float b, float a, float a2) {
    super(r, g, b, a);
    color2[0] = r;
    color2[1] = g;
    color2[2] = b;
    color2[3] = a2;
  }
  /**
   * Create a particles colors.
   * @param r the red color component of the initial color
   * @param g the green color component of the initial color
   * @param b the blue color component of the initial color
   * @param a the alpha color component of the initial color
   * @param r2 the red color component of the final color
   * @param g2 the green color component of the final color
   * @param b2 the blue color component of the final color
   * @param a2 the alpha color component of the final color
   */
  public ChangingParticlesColors(float r, float g, float b, float a, float r2, float g2, float b2, float a2) {
    super(r, g, b, a);
    color2[0] = r2;
    color2[1] = g2;
    color2[2] = b2;
    color2[3] = a2;
  }
  
  /**
   * Clones this changing particles colors.
   * @return the clone
   */
  public Object clone() {
    ChangingParticlesColors o = (ChangingParticlesColors) super.clone();
    System.arraycopy(color2, 0, o.color2, 0, 4);
    
    return o;
  }
  
  public void advanceParticle(int id, float factor) {
    //colors[id * 4 + 3] = color[3] * bunch.lifes.lifes[id] + fadeToAlpha * (1f - bunch.lifes.lifes[id]);
    float f1 = bunch.lifes.lifes[id], f2 = 1f - f1;
    id = id * 4;
    colors[id    ] = color[0] * f1 + color2[0] * f2;
    colors[id + 1] = color[1] * f1 + color2[1] * f2;
    colors[id + 2] = color[2] * f1 + color2[2] * f2;
    colors[id + 3] = color[3] * f1 + color2[3] * f2;
  }
  
  /*
  public boolean getUseAlpha() { return true; }
  
  protected float fadeToAlpha;
  public float getFadeToAlpha() { return fadeToAlpha; }
  public void setFadeToAlpha(float f) {
    fadeToAlpha = f;
    firePropertyChange("fadeToAlpha");
  }
  */
  
  protected final float[] color2 = (float[]) Material.WHITE_COLOR.clone();
  public float[] getColor2() {	return color2; }
  public void setColor2(float red, float green, float blue) { setColor2(red, green, blue, 1f); }
  public void setColor2(float red, float green, float blue, float alpha) {
    color2[0] = red;
    color2[1] = green;
    color2[2] = blue;
    color2[3] = alpha;
    firePropertyChange("color2");
  }
  public void setColor2(float[] c) {
    System.arraycopy(c, 0, color2, 0, 4);
    firePropertyChange("color2");
  }
  public float getRed2  () { return color2[0]; }
  public float getGreen2() { return color2[1]; }
  public float getBlue2 () { return color2[2]; }
  public float getAlpha2() { return color2[3]; }
  public void setRed2  (float f) {
    color2[0] = f;
    firePropertyChange("color2");
  }
  public void setGreen2(float f) {
    color2[1] = f;
    firePropertyChange("color2");
  }
  public void setBlue2 (float f) {
    color2[2] = f;
    firePropertyChange("color2");
  }
  public void setAlpha2(float f) {
    color2[3] = f;
    firePropertyChange("color2");
  }
  
  public boolean getUseAlpha() { return (color[3] != 1f) || (color2[3] != 1f); }
}
