/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.animation;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import java.io.*;
import java.beans.*;
import java.util.Iterator;

public class MovementState extends Object implements Serializable, Cloneable {
  private static final long serialVersionUID = -9144906974784225299l;
  public MovementState(float time, GraphicalElement3D ge) {
    this.time = time;
    
    float[] f = ge.getMatrix();
    x = f[12];
    y = f[13];
    z = f[14];
    
    inclineValue = ge.getInclineValue();
    
    width  = ge.getXFactor();
    height = ge.getYFactor();
    depth  = ge.getZFactor();
    
    quaternion = Quaternion.quaternionFromGraphical(ge);
  }
  private MovementState(MovementState ms) {
    time = ms.time;
    quaternion = (float[]) ms.quaternion.clone();
    inclineValue  = ms.inclineValue ;
    x = ms.x;
    y = ms.y;
    z = ms.z;
    width  = ms.width ;
    height = ms.height;
    depth  = ms.depth ;
  }
  
  public Object clone() { return new MovementState(this); }
  
  public float time;
  public final float[] quaternion;
  public final float inclineValue;
  public final float x;
  public final float y;
  public final float z;
  public final float width;
  public final float height;
  public final float depth;
  
  public String toString() {
    return "time : " + time + "\n"
      + "x : " + x + "\n"
      + "y : " + y + "\n"
      + "z : " + z + "\n"
      + "quaternion :\n" + Quaternion.quaternionToString(quaternion) + "\n"
      + "incline value   : " + inclineValue + "\n"
      + "width  : " + width + "\n"
      + "height : " + height + "\n"
      + "depth  : " + depth;
  }
}
