/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.animation;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import java.io.*;
import java.beans.*;
import java.util.Iterator;

public class InterpolatedState extends Object implements Serializable {
  public InterpolatedState(MovementState s) {
    width = s.width;
    height = s.height;
    depth = s.depth;
    inclineValue = s.inclineValue;
    
    matrix = Matrix.matrixScale(
                                Matrix.matrixTranslate(
                                                       Quaternion.matrixFromQuaternion(s.quaternion),
                                                       s.x, s.y, s.z
                                                       ),
                                width, height, depth
                                );
  }
  public InterpolatedState(MovementState s1, MovementState s2, float time) {
    float f2 = (time - s1.time) / (s2.time - s1.time);
    float f1 = 1 - f2;

    width = f1 * s1.width + f2 * s2.width;
    height = f1 * s1.height + f2 * s2.height;
    depth = f1 * s1.depth + f2 * s2.depth;
    inclineValue = f1 * s1.inclineValue + f2 * s2.inclineValue;
    if(inclineValue > 180f) inclineValue = inclineValue - 360f;
    else if(inclineValue <= -180f) inclineValue = inclineValue + 360f;
    
    matrix = Matrix.matrixScale(
                                Matrix.matrixTranslate(
                                                       Quaternion.matrixFromQuaternion(Quaternion.quaternionSlerp(s1.quaternion, s2.quaternion, f2)),
                                                       f1 * s1.x + f2 * s2.x, f1 * s1.y + f2 * s2.y, f1 * s1.z + f2 * s2.z
                                                       ),
                                width, height, depth
                                );
  }
  public InterpolatedState(float f2, MovementState s1, MovementState s2) {
    float f1 = 1 - f2;

    width = f1 * s1.width + f2 * s2.width;
    height = f1 * s1.height + f2 * s2.height;
    depth = f1 * s1.depth + f2 * s2.depth;
    inclineValue = f1 * s1.inclineValue + f2 * s2.inclineValue;
    
    matrix = Matrix.matrixScale(
                                Matrix.matrixTranslate(
                                                       Quaternion.matrixFromQuaternion(Quaternion.quaternionSlerp(s1.quaternion, s2.quaternion, f2)),
                                                       f1 * s1.x + f2 * s2.x, f1 * s1.y + f2 * s2.y, f1 * s1.z + f2 * s2.z
                                                       ),
                                width, height, depth
                                );
  }
  
  public float[] matrix;
  public       float inclineValue;
  public final float width;
  public final float height;
  public final float depth;
  
  public String toString() {
    return "matrix :\n" + Matrix.matrixToString(matrix) + "\n"
      + "incline value   : " + inclineValue + "\n"
      + "width  : " + width + "\n"
      + "height : " + height + "\n"
      + "depth  : " + depth;
  }
}

