/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.animation;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.animation.*;
import opale.soya.editor.*;
import java.util.Iterator;
import java.beans.*;
import java.awt.*;
import java.awt.event.*;

public class AnimationsCustomizer extends Panel implements CollectionListener, Customizer {
  public AnimationsCustomizer(Animations animations, World3D world) {
    super(new BorderLayout());
    
    as = animations;
    as.addCollectionListener(this);
    as.addSubPropertyChangeListener(new PropertyChangeListener() {
      public void propertyChange(PropertyChangeEvent e) {
        if("name".equals(e.getPropertyName())) rebuildList();
      }
    });
    w = world;
    
    list = new java.awt.List();
    for(Iterator i = as.iterator(); i.hasNext(); ) list.add(((Animation) i.next()).getName());
    list.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { edit(); }
    });
    add(list, BorderLayout.CENTER);
    
    p = new Panel(new GridLayout(5, 1));
    add(p, BorderLayout.SOUTH);
    
    Button add = new Button("Add new");
    add.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        as.add(new Animation("new"));
      }
    });
    p.add(add);
    
    Button clone = new Button("Clone");
    clone.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        String name = list.getSelectedItem();
        if(name == null) return;
        as.add(as.animation(name).clone());
      }
    });
    p.add(clone);
    
    Button edit = new Button("Edit...");
    edit.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { edit(); }
    });
    p.add(edit);
    
    Button delete = new Button("Delete");
    delete.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        String name = list.getSelectedItem();
        if(YesNoDialog.question(getFrame(), "Confirmation", "Really delete animation : " + name + " ?") == true) {
          if(name != null) as.remove(name);
        }
      }
    });
    p.add(delete);
    
    Button save = new Button("Save");
    save.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        try { as.save(); }
        catch(Exception ex) { System.out.println("Can't save animations!"); ex.printStackTrace(); }
      }
    });
    p.add(save);
    
    p.doLayout();
  }
  public void finalize() {
    as.removeCollectionListener(this);
  }
  
  private Panel p;
  public void doLayout() {
    super.doLayout();
    p.doLayout();
  }
  
  private Animations as;
  public void setObject(Object o) { as = (Animations) o; }
  private World3D w;
  
  public java.awt.Dimension getPreferredSize() { return new java.awt.Dimension(150, 250); }
  
  public void addPropertyChangeListener(PropertyChangeListener l) {  }
  public void removePropertyChangeListener(PropertyChangeListener l) {  }
  
  private void edit() {
    String name = list.getSelectedItem();
    if(name != null) {
      Animation a = as.animation(name);
      try { Editor.edit(a, false, new AnimationCustomizer(a, w)); }
      catch(Exception e) { System.out.println("Can't edit animation!"); e.printStackTrace(); }
    }
  }
  
  java.awt.List list;
  
	public synchronized void added  (AddEvent    e) { rebuildList(); }
	public synchronized void removed(RemoveEvent e) { rebuildList(); }
  private void rebuildList() {
    int index = list.getSelectedIndex();
    list.removeAll();
    for(Iterator i = as.iterator(); i.hasNext(); ) list.add(((Animation) i.next()).getName());
  }
  
  private java.awt.Frame getFrame() {
    Component c = this;
    while(true) {
      c = c.getParent();
      if(c instanceof java.awt.Frame) return (java.awt.Frame) c;
    }
  }
}
