/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

/**
 * Interface for all object that support basic raypicking methods.
 * 
 * @author Artiste on the Web
 */

public interface Raypicking {
  /** Constant for sens. */
  public static int SENS_STRAIGHT_LINE = 0;
  public static int SENS_HALF_LINE = 1;
  
  /** Constant for intersection. */
  public static int INTERSECTION_ALL = 0;
  public static int INTERSECTION_ONLY_VISIBLE = 1;
  
  /**
   * Test if raypicking is really necessary.
   * @param distanceSquarred the distance of the object, squarred
   * @return if false, raypick is not necessary
   */
  public boolean ensureRaypickIsUsefull(float distanceSquarred);
  
  /**
   * Returns the position of the intersection between this object and the given ray.
   * Only the nearest intersection to origin is returned.
   * @param origin the origin of the ray
   * @param direction the direction of the ray
   * @param sens a SENS_* constant that indicates if the ray is a straight or a half line
   * @param intersection a INTERSECTION_* constant that indicates if the method takes in
   * account intersection with backfaced face
   */
  public Position raypick(Position origin, Vector direction, int sens, int intersection);
  /**
   * Returns the number of intersections between this object and the given ray.
   * @param origin the origin of the ray
   * @param direction the direction of the ray
   * @param sens a SENS_* constant that indicates if the ray is a straight or a half line
   * @param intersection a INTERSECTION_* constant that indicates if the method takes in
   * account intersection with backfaced face
   * @param maxLength the maximum distance for the intersection
   * @return the number of intersection
   */
  public int raypickNumber(Position origin, Vector direction, int sens, int intersection, float maxLenght);
  /**
   * Checks if there is any intersection between this object and the given ray.
   * @param origin the origin of the ray
   * @param direction the direction of the ray
   * @param sens a SENS_* constant that indicates if the ray is a straight or a half line
   * @param intersection a INTERSECTION_* constant that indicates if the method takes in
   * account intersection with backfaced face
   * @param maxLength the maximum distance for the intersection
   * @return true if the ray intersects this object
   */
  public boolean raypickBoolean(Position origin, Vector direction, int sens, int intersection, float maxLenght);
}

