/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

import opale.soya.*;
import java.beans.*;

/**
 * @author Artiste on the Web
 */

public class Environment3DBeanInfo extends opale.soya.util.AbstractBeanInfo {
  public Environment3DBeanInfo() { 
    super(true, false, false); 

    PropertyDescriptor[] pd = new PropertyDescriptor[14];
    try {      
      pd[ 0] = new PropertyDescriptor("fogEnabled", getBeanClass());
      pd[ 1] = new PropertyDescriptor("fogType", getBeanClass());
      pd[ 1].setPropertyEditorClass(opale.soya.soya3d.FogTypePropertyEditor.class);
      pd[ 2] = new PropertyDescriptor("fogStart", getBeanClass());
      pd[ 3] = new PropertyDescriptor("fogEnd", getBeanClass());
      pd[ 4] = new PropertyDescriptor("fogDensity", getBeanClass());
      pd[ 5] = new PropertyDescriptor("ambientRed", getBeanClass());
      pd[ 6] = new PropertyDescriptor("ambientGreen", getBeanClass());
      pd[ 7] = new PropertyDescriptor("ambientBlue", getBeanClass());
      pd[ 8] = new PropertyDescriptor("ambientAlpha", getBeanClass());
      pd[ 9] = new PropertyDescriptor("backgroundRed", getBeanClass());
      pd[10] = new PropertyDescriptor("backgroundGreen", getBeanClass());
      pd[11] = new PropertyDescriptor("backgroundBlue", getBeanClass());
      pd[12] = new PropertyDescriptor("backgroundAlpha", getBeanClass());
      pd[13] = new PropertyDescriptor("backgroundImage", getBeanClass());
    }
    catch(Exception e) {
      System.out.println(getClass().getName() + " : error");
      e.printStackTrace();
    }
    addPropertyDescriptors(pd);
  }

  public BeanDescriptor getBeanDescriptor() {
    return new BeanDescriptor(getBeanClass(), opale.soya.soya3d.World3DCustomizer.class);
  }
}
