/*
 * Soya3D
 * Copyright (C) 1999 - 2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

import opale.soya.*;

/**
 * A dimension warpper is an object that can be used to convert dimensions from a coordinates
 * system to another.
 * 
 * Example :
 * DimensionWrapper dw = myDimension.wrapper();
 * dw.setCoordSyst(theCoordinatesSystemInWhichYouWantTheDimensions);
 * System.out.println("The witdh is " + dw.getWidth()); // Use the dimension.
 * 
 * @author Artiste on the Web
 */

public interface DimensionWrapper extends Dimension {
  /**
   * Gets the position of the wrapped dimension that has the lower coordinates values (For
   * example the lower-left-front corner of a box).
   * @return the minimum position
   */
  public Position getMin();
  /**
   * Gets the position of the wrapped dimension that has the higher coordinates values (For
   * example the higher-right-back corner of a box).
   * @return the maximum position
   */
  public Position getMax();
  
  /**
   * Gets the origin/center of the wrapped dimension.
   * @return the origin
   */
  public Position getOrigin();

  /**
   * Gets the initial coordinates system (in which the dimension wrapped by this object is
   * defined : the one of the dimension we wrap).
   * @return the initial coordinates system
   */
  public CoordSyst getInitialCoordSyst();
  /**
   * Gets the current coordinates system, in which the dimension of this wrapper are defined.
   * Default value is getInitialCoordSyst() .
   * @return the coordinates system
   */
  public CoordSyst getCoordSyst();
  /**
   * Sets the current coordinates system, in which the dimension of this wrapper are defined.
   * A coordinates conversion is performed.
   * @param cs the coordinates system
   */
  public void setCoordSyst(CoordSyst cs);
  
  /**
   * Minimizes the given position by the dimension.
   * Rather useless for end-user...
   * @param f the position
   */
  public void minimize(Position p);
  /**
   * Maximizes the given position by the dimension.
   * Rather useless for end-user...
   * @param f the position
   */
  public void maximize(Position p);
  
  /**
   * Gets the radius of the wrapper, squared.
   * @return the radius
   */
  public float getSquareRadius();
}
