/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

import opale.soya.*;
import java.beans.*;

/**
 * @author Artiste on the Web
 */

public class DimensionBeanInfo extends opale.soya.util.AbstractBeanInfo {
  public DimensionBeanInfo() { 
    super(true, false, false); 

    PropertyDescriptor[] pd = new PropertyDescriptor[7];
    try {
      pd[0] = new PropertyDescriptor("width" , getBeanClass());
      pd[1] = new PropertyDescriptor("height", getBeanClass());
      pd[2] = new PropertyDescriptor("depth" , getBeanClass());
      pd[3] = new PropertyDescriptor("coordSyst", getBeanClass(), "getCoordSyst", null);
      pd[3].setHidden(true);
      pd[4] = new PropertyDescriptor("xFactor", getBeanClass());
      pd[5] = new PropertyDescriptor("yFactor", getBeanClass());
      pd[6] = new PropertyDescriptor("zFactor", getBeanClass());
      /*
      pd[7] = new PropertyDescriptor("dims", getBeanClass(), "getDims", null);
      pd[7].setHidden(true);
      pd[8] = new PropertyDescriptor("factors", getBeanClass(), "getFactors", null);
      pd[8].setHidden(true);
      */
    }
    catch(Exception e) {
      System.out.println(getClass().getName() + " : error");
      e.printStackTrace();
    }
    addPropertyDescriptors(pd);
  }
}
