/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.editor.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.event.*;
import java.beans.*;
import java.awt.event.*;

/**
 * Handle used by WorldGUIEditor for handling position.
 * 
 * @author Artiste on the Web
 */

class AtomicHandle3D extends Handle3D implements PropertyChangeListener {
  public AtomicHandle3D() { super(BLUE);  }
  public AtomicHandle3D(GraphicalElement3D a) {
    this();
    setAtomic(a);
  }

  private GraphicalElement3D atomic;
  public GraphicalElement3D getAtomic() { return atomic; }
  public Object getEditedObject() { return atomic; }
  public synchronized void setAtomic(GraphicalElement3D a) { 
    if(atomic != null) atomic.removePropertyChangeListener(this);
    atomic = a;
    if(atomic != null) {
      atomic.addPropertyChangeListener(this);
      move(atomic);
    }
    firePropertyChange("atomic"); 
  }
  public void propertyChange(PropertyChangeEvent e) {
    if(e instanceof MoveEvent) update();
  }
  
  public void update() { move(atomic); }

  // Overrides :
  public void added(World3D into) {
    super.added(into);
    update();
  }
  
  protected void doSelection(boolean selected) {  }
  protected void doClick(boolean clicked) {  }
  protected synchronized void doMovement(Cursor3D c, Position position, MouseEvent e) {
    atomic.move(position);
  }
}
