/*
 * Soya3D
 * Copyright (C) 1999  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya2d;

import opale.soya.*;
import opale.soya.awt.*;
import gl4java.*;
import java.util.*;
import java.awt.*;
import java.awt.image.*;
import java.io.*;

/**
 * An image that can be used for drawing textured surfaces.
 *
 * The texture is considered as a material property (unlike in openGL or many other 3D
 * engine).
 * See Material.setTexture() for how to specify the texture.
 * 
 * @author Artiste on the Web
 */

public abstract class Texture extends opale.soya.soya2d.Image {
  private static final long serialVersionUID = 8006159139374402804l;
  
  protected transient int id;
  protected void finalize() {
    Soya.releaseTextureID(id);
  }
  
  // Serializable :
  /*
  private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException { // Initialization.
    s.defaultReadObject();
    build();
  }
  */

  /**
   * Builds the texture after loading or changing a property. Automatically called when necessary.
   * Child-class can override this method; they should call this implementation before doing anything.
   */
  protected synchronized void build(GLFunc gl, GLUFunc glu) {
    //if(id == 0) id = Soya.newTextureID();
    if(id == 0) {
      int[] ids = new int[1];
      gl.glGenTextures(1, ids);
      id = ids[0];
    }
    gl.glBindTexture(GLEnum.GL_TEXTURE_2D, id);
    
    Quality.makeQualityCurrentForTexture(gl, glu);
    /*
    switch(Quality.quality) {
    case Quality.QUALITY_LOW:
      gl.glTexParameterf(GLEnum.GL_TEXTURE_2D, GLEnum.GL_TEXTURE_MIN_FILTER, GLEnum.GL_NEAREST);
      gl.glTexParameterf(GLEnum.GL_TEXTURE_2D, GLEnum.GL_TEXTURE_MAG_FILTER, GLEnum.GL_NEAREST);
      break;
    case Quality.QUALITY_NORMAL:
      gl.glTexParameterf(GLEnum.GL_TEXTURE_2D, GLEnum.GL_TEXTURE_MIN_FILTER, GLEnum.GL_NEAREST);
      gl.glTexParameterf(GLEnum.GL_TEXTURE_2D, GLEnum.GL_TEXTURE_MAG_FILTER, GLEnum.GL_NEAREST);
      //gl.glTexParameterf(GLEnum.GL_TEXTURE_2D, GLEnum.GL_TEXTURE_MAG_FILTER, GLEnum.GL_LINEAR);
      break;
    case Quality.QUALITY_HIGH:
      gl.glTexParameterf(GLEnum.GL_TEXTURE_2D, GLEnum.GL_TEXTURE_MIN_FILTER, GLEnum.GL_LINEAR);
      gl.glTexParameterf(GLEnum.GL_TEXTURE_2D, GLEnum.GL_TEXTURE_MAG_FILTER, GLEnum.GL_LINEAR);
    }
    */
    gl.glTexParameterf(GLEnum.GL_TEXTURE_2D, GLEnum.GL_TEXTURE_WRAP_S, GLEnum.GL_REPEAT);
    gl.glTexParameterf(GLEnum.GL_TEXTURE_2D, GLEnum.GL_TEXTURE_WRAP_T, GLEnum.GL_REPEAT);
    
    isBuilt = true;
  }
  
  protected transient boolean isBuilt;
  /**
   * Invalidates the current GL data.
   */
  protected void reBuild() { isBuilt = false; }
  
  // Overrides :
  public synchronized void setImage(java.awt.Image i) throws InterruptedException {
    super.setImage(i);
    reBuild();
  }
  
  /**
   * Make this texture current for the future openGL drawing.
   * @param gl  the gl
   * @param glu the glu
   */
  public void makeCurrent(GLFunc gl, GLUFunc glu) {
    if(getImageData() != null) { // else : useless, and may crash Mesa (if no texture exist and GL_TEXTURE_2D is set enabled)?
      if(!isBuilt) build(gl, glu);
      if(!gl.glIsEnabled(GLEnum.GL_TEXTURE_2D)) gl.glEnable(GLEnum.GL_TEXTURE_2D);
      gl.glBindTexture(GLEnum.GL_TEXTURE_2D, id);
    }
  }
  /**
   * Release the use of this texture for the future openGL drawing, and reset any changed
   * state to its initial value (=before makeCurrent(GLFunc, GLUFunc)).
   * @param gl  the gl
   * @param glu the glu
   */
  public void unmakeCurrent(GLFunc gl, GLUFunc glu) {  }
  
  
  public void draw(GLFunc gl, GLUFunc glu, int x, int y) { draw(gl, glu, x, y, getWidth(), getHeight()); }
  public void draw(GLFunc gl, GLUFunc glu, int x, int y, int width, int height) {
    makeCurrent(gl, glu);
    gl.glBegin(GLEnum.GL_QUADS);
    gl.glTexCoord2f(0f, 0f);
    gl.glVertex3f(x, y, 0f);
    gl.glTexCoord2f(1f, 0f);
    gl.glVertex3f(x + width, y, 0f);
    gl.glTexCoord2f(1f, 1f);
    gl.glVertex3f(x + width, y + height, 0f);
    gl.glTexCoord2f(0f, 1f);
    gl.glVertex3f(x, y + height, 0f);
    gl.glEnd();
    unmakeCurrent(gl, glu);
  }
}
