/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya2d;

import opale.soya.*;
import opale.soya.soya2d.*;
import opale.soya.util.*;
import opale.soya.editor.*;
import java.beans.*;
import java.io.*;

/**
 * @author Artiste on the Web
 */

public class MaterialEditorWriteOnly extends StoredInPathObjectEditorWriteOnly {
  public MaterialEditorWriteOnly() { super(); }
  
  /*
  public void setAsText(String t) throws IllegalArgumentException {
    if(t == NO_STRING   ) { setValue(Material.WHITE_MATERIAL); return; }
    if(t == OTHER_STRING) { setValue(new Material())      ; return; }
    try { setValue(Material.get(t)); }
    catch(Exception e) { System.out.println("Can't find material : " + t); e.printStackTrace(); }
  }
  */
  
  protected StoredInPathObject getNull () { return Material.WHITE_MATERIAL; }
  protected StoredInPathObject getNew  () { return new Material(); }
  protected StoredInPathObject getNamed(String name) {
    try { return Material.get(name); }
    catch(Exception e) {
      System.out.println("Can't find material : " + name);
      e.printStackTrace();
    }
    return getNull();
  }
  protected StoredInPathObject list() {
    try {
      String name = StoredInPathObjectChooser.question(getFrame(), Material.path, "material", true);
      if(name == null) return Material.WHITE_MATERIAL;
      return Material.get(name); 
    }
    catch(Exception e) { System.out.println("can't find or list materials!"); e.printStackTrace(); }
    return Material.WHITE_MATERIAL;
  }
  private java.awt.Frame getFrame() {
    java.awt.Component c = getCustomEditor();
    while(true) {
      c = c.getParent();
      if(c instanceof java.awt.Frame) return (java.awt.Frame) c;
    }
  }
  
  private String[] tags = computeTags(Material.path, ".material");
  public String[] getTags() { return tags; }
}
