/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya2d;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.awt.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import opale.soya.soya3d.model.Shape;
import opale.soya.editor.*;
import java.beans.*;
import java.lang.reflect.*;
import java.awt.*;
import java.awt.event.*;

public class MaterialCustomizer extends RenderingCanvas implements Customizer {
  public MaterialCustomizer() { super(150, 200); }

  private Material m;
  public void setObject(Object o) { 
    m = (Material) o;
    init();
  }

  public java.awt.Dimension getPreferredSize() { return new java.awt.Dimension(150, 200); }

  public void addPropertyChangeListener(PropertyChangeListener l) {  }
  public void removePropertyChangeListener(PropertyChangeListener l) {  }

	private World3D scene;
	public void init() {
		if(scene == null) create();
	}
  public void create() {
    Environment3D scene = new Environment3D();
    scene.setAmbientColor(0.55f, 0.55f, 0.55f);

    final Volume3D v = new Volume3D(buildShape(m));
    scene.add(v);
    v.move(0f, 0f, 0f);
    v.scale(3f);
		v.rotateLateral(45);
    v.rotateVertical(-30);
    
    Camera3D c = new Camera3D();
    scene.add(c);
    c.move(0f, .5f, 4f);
    c.setFOV(75f);
    
    Light3D l = new Light3D();
    scene.add(l);
    l.setColor(1f ,1f ,1f);
    l.move(1f, 0f, 2f);
    l.setAttenuation(0f, .5f, 0f);
    
    setRenderer(c);
    addMouseListener(new MouseAdapter() {
      private Thread rotingThread;
      public void mouseClicked(MouseEvent e) {
        if(rotingThread == null) {
          rotingThread = new Thread() {
            public void run() {
              for(int i = 0; i < 180; i++) {
                v.rotateLateral(1f);
                render();
                try { Thread.currentThread().sleep(25); }
                catch(Exception ex) {  }
                
              }
              rotingThread = null;
            }
          };
          rotingThread.start();
        }
      }
    });

    v.addPropertyChangeListener(new ChangeRenderer());
  }

  private class ChangeRenderer implements PropertyChangeListener {
    public void propertyChange(PropertyChangeEvent e) { repaint(); }
  }
  private static FragmentedShape buildShape(Material m) {
    FragmentedShape s = new FragmentedShape();
    s.lock();
    s.add(new Quad(new AdvancedPoint(-.5f, -.5f, -.5f, 1f, 1f),
                   new AdvancedPoint(-.5f,  .5f, -.5f, 1f, 0f),
                   new AdvancedPoint( .5f,  .5f, -.5f, 0f, 0f),
                   new AdvancedPoint( .5f, -.5f, -.5f, 0f, 1f),
                   m));
    s.add(new Quad(new AdvancedPoint(-.5f, -.5f,  .5f, 0f, 1f),
                   new AdvancedPoint(-.5f,  .5f,  .5f, 0f, 0f),
                   new AdvancedPoint( .5f,  .5f,  .5f, 1f, 0f),
                   new AdvancedPoint( .5f, -.5f,  .5f, 1f, 1f),
                   m));

    s.add(new Quad(new AdvancedPoint(-.5f, -.5f, -.5f, 1f, 1f),
                   new AdvancedPoint(-.5f,  .5f, -.5f, 1f, 0f),
                   new AdvancedPoint(-.5f,  .5f,  .5f, 0f, 0f),
                   new AdvancedPoint(-.5f, -.5f,  .5f, 0f, 1f),
                   m));
    s.add(new Quad(new AdvancedPoint( .5f, -.5f, -.5f, 0f, 1f),
                   new AdvancedPoint( .5f,  .5f, -.5f, 0f, 0f),
                   new AdvancedPoint( .5f,  .5f,  .5f, 1f, 0f),
                   new AdvancedPoint( .5f, -.5f,  .5f, 1f, 1f),
                   m));

    s.add(new Quad(new AdvancedPoint(-.5f, -.5f, -.5f),
                   new AdvancedPoint( .5f, -.5f, -.5f),
                   new AdvancedPoint( .5f, -.5f,  .5f),
                   new AdvancedPoint(-.5f, -.5f,  .5f),
                   m));
    s.add(new Quad(new AdvancedPoint(-.5f,  .5f, -.5f),
                   new AdvancedPoint( .5f,  .5f, -.5f),
                   new AdvancedPoint( .5f,  .5f,  .5f),
                   new AdvancedPoint(-.5f,  .5f,  .5f),
                   m));
    s.setVisibility(FaceVisibility.VISIBILITY_ALL);
    s.unlock();
    return s;
  }
}
