/*
 * Soya3D
 * Copyright (C) 1999  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.font;

import opale.soya.*;
import gl4java.*;

/**
 * A font for drawing 2D text.
 * 
 * @author Artiste on the Web
 */

public interface Font2D {
  /**
   * Gets a description of this font.
   * @return the description
   */
  public String getDescription();
  /**
   * Gets the width of the given string, drawn with this font.
   * @return the width in pixel
   */
  public int getStringWidth(String s);
  /**
   * Gets the height of the given string, drawn with this font.
   * @return the height in pixel
   */
  public int getStringHeight(String s);

  /**
   * Draws the given string at the given 2D position.
   * @param x the horizontal position in pixel
   * @param y the vertical position in pixel
   */
  public void draw(GLFunc gl, GLUFunc glu, String s, int x, int y);
  /**
   * Draws the given string at the given 3D position.
   * @param x the x position in 3D coordinates
   * @param y the y position in 3D coordinates
   * @param z the z position in 3D coordinates
   */
  public void draw(GLFunc gl, GLUFunc glu, String s, float x, float y, float z);
}
