/*
 * Soya3D
 * Copyright (C) 1999  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.font;

import opale.soya.*;
import gl4java.*;
import gl4java.utils.glut.*;
import gl4java.utils.glut.fonts.*;
import java.io.*;

/**
 * Defines standard default 2D fonts.
 * 
 * @author Artiste on the Web
 */

public class DefaultFont2D extends Object implements Font2D, Serializable {
  private DefaultFont2D(int newId, int newHeight) {
    id = newId;
    height = newHeight;
  }
  
  //public static final int FONT_TYPE_BITMAP = 0;
  //public static final int FONT_TYPE_STROKE = 1;
  
  /** Bitmap font 8 * 13. */ 
  public static final Font2D BITMAP_8_13 = new DefaultFont2D(GLUTEnum.GLUT_BITMAP_8_BY_13, 13);
  /** Bitmap font 9 * 15. */ 
  public static final Font2D BITMAP_9_15 = new DefaultFont2D(GLUTEnum.GLUT_BITMAP_9_BY_15, 15);
  /** Helvetica font, size = 10. */ 
  public static final Font2D HELVETICA_10 = new DefaultFont2D(GLUTEnum.GLUT_BITMAP_HELVETICA_10, 10);
  /** Helvetica font, size = 12. */ 
  public static final Font2D HELVETICA_12 = new DefaultFont2D(GLUTEnum.GLUT_BITMAP_HELVETICA_12, 12);
  /** Helvetica font, size = 18. */ 
  public static final Font2D HELVETICA_18 = new DefaultFont2D(GLUTEnum.GLUT_BITMAP_HELVETICA_18, 18);
  /** Time roman font, size = 10. */ 
  public static final Font2D TIMES_ROMAN_10 = new DefaultFont2D(GLUTEnum.GLUT_BITMAP_TIMES_ROMAN_10, 10);
  /** Time roman font, size = 24. */ 
  public static final Font2D TIMES_ROMAN_24 = new DefaultFont2D(GLUTEnum.GLUT_BITMAP_TIMES_ROMAN_24, 24);
  /* Mono roman font. */ 
  //public static final Font2D MONO_ROMAN = new DefaultFont2D(GLUTEnum.GLUT_STROKE_MONO_ROMAN, FONT_TYPE_STROKE, 12);
  /* Roman font. */ 
  //public static final Font2D ROMAN = new DefaultFont2D(GLUTEnum.GLUT_STROKE_ROMAN, FONT_TYPE_STROKE, 12);
  
  private int height;
  private int id;
  private int type;
  
  public String getDescription() { return Soya.getGLUT().glutGetFontDescription(id); }
  public int getStringWidth(String s) { return Soya.getGLUT().glutBitmapLength(id, s); }
  public int getStringHeight(String s) { // Not very good.......
    return height;
  }
  public void draw(GLFunc gl, GLUFunc glu, String s, int x, int y) {
    gl.glRasterPos3f((float) x, (float) y, .5f);
    Soya.getGLUT(gl, glu).glutBitmapString(id, s);
  }
  public void draw(GLFunc gl, GLUFunc glu, String s, float x, float y, float z) {
    gl.glRasterPos3f(x, y, z);
    Soya.getGLUT(gl, glu).glutBitmapString(id, s);
  }
  
  public static Font2D getFont(String description) {
    if(description.equals(BITMAP_8_13.getDescription())) return BITMAP_8_13;
    if(description.equals(BITMAP_9_15.getDescription())) return BITMAP_9_15;
    if(description.equals(HELVETICA_10.getDescription())) return HELVETICA_10;
    if(description.equals(HELVETICA_12.getDescription())) return HELVETICA_12;
    if(description.equals(HELVETICA_18.getDescription())) return HELVETICA_18;
    if(description.equals(TIMES_ROMAN_10.getDescription())) return TIMES_ROMAN_10;
    if(description.equals(TIMES_ROMAN_24.getDescription())) return TIMES_ROMAN_24;
    return null;
  }
}
