/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import opale.soya.*;
import java.awt.*;
import java.awt.event.*;

/**
 * A dialog box that ask a yes/no question.
 * 
 * @author Artiste on the Web
 */

public class YesNoDialog extends Dialog {
  /**
   * Creates a new yes/no dialog box.
   * @param owner the owner frame
   * @param title the title
   * @param text  the question
   */
  public YesNoDialog(Frame owner, String title, String text) {
    super(owner, title, true);

    setLayout(new GridLayout(3, 1));

    add(new Label(text));

    yes = new Button("Yes");
    yes.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        dispose();
        answer = true;
      }
    });
    add(yes);

    no = new Button("No");
    no.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        dispose();
        answer = false;
      }
    });
    add(no);

    //setBounds(150, 100, 150, 150);
   setSize(400, 150);
  }

  private Button yes;
  private Button no;
  private boolean answer;
  /**
   * Gets the anwer.
   * @return true for yes
   */
  public boolean getAnswer() { return answer; }

  /**
   * Ask a yes/no question.
   * @param owner the owner frame
   * @param text  the question
   * @return true for yes
   */
  public static boolean question(Frame owner, String text) { return question(owner, text, text); }
  /**
   * Ask a yes/no question.
   * @param owner the owner frame
   * @param title the title
   * @param text  the question
   * @return true for yes
   */
  public static boolean question(Frame owner, String title, String text) {
    YesNoDialog yesNo = new YesNoDialog(owner, title, text);
    yesNo.setVisible(true);
    return yesNo.answer;
  }
}
