/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;

public class PropertyTextWriteOnly extends Button implements ActionListener {
  public PropertyTextWriteOnly(PropertyEditor pe) { this(pe, "set... (write only)"); }
  public PropertyTextWriteOnly(PropertyEditor pe, String buttonText) {
    super(buttonText);
    editor = pe;
    addActionListener(this);
  }

  private PropertyEditor editor;

  public void actionPerformed(ActionEvent e) {
    try { editor.setAsText(TextChooser.question(getFrame(), "Enter new value")); }
    catch(Exception e2) { System.out.println("Can't set " + editor); e2.printStackTrace(); }
  }
  
  private java.awt.Frame getFrame() {
    Component c = this;
    while(true) {
      c = c.getParent();
      if(c instanceof java.awt.Frame) return (java.awt.Frame) c;
    }
  }
}
/*
class PropertyTextWriteOnly extends Container implements ActionListener {
  public PropertyTextWriteOnly(PropertyEditor pe) { this(pe, "set"); }
  public PropertyTextWriteOnly(PropertyEditor pe, String buttonText) {
    editor = pe;

    setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));

    t = new TextField();
    t.setText("");
    t.setSize(100, getHeight());
    add(t);

    b = new Button(buttonText);
    add(b);
    b.addActionListener(this);
  }

  private PropertyEditor editor;
  private TextField t;
  private Button b;

  public void actionPerformed(ActionEvent e) {
    try { editor.setAsText(t.getText()); }
    catch(Exception e2) { System.out.println("Can't set " + editor); e2.printStackTrace(); }
  }

  public void repaint() {
    t.setText("");
  }
}
*/
