/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;

public class PropertySelectorWriteOnly extends Choice implements ItemListener {
  public PropertySelectorWriteOnly(PropertyEditor pe) { this(pe, pe.getTags()); }
  public PropertySelectorWriteOnly(PropertyEditor pe, String[] tags) {
  	editor = pe;
    addItem(WRITE_ONLY_TEXT);
	  for (int i = 0; i < tags.length; i++) addItem(tags[i]);
	  select(0);
  	addItemListener(this);
  }
  
  private static final String WRITE_ONLY_TEXT = "(write only)";
  
  private PropertyEditor editor;
  
  public void itemStateChanged(ItemEvent e) {
	  String s = getSelectedItem();
    if(!WRITE_ONLY_TEXT.equals(s)) editor.setAsText(s);
    select(0);
  }
  
  public void repaint() { select(0); }
}
/*
class PropertySelectorWriteOnly extends Container implements ActionListener {
  public PropertySelectorWriteOnly(PropertyEditor pe) { this(pe, "set", pe.getTags()); }
  public PropertySelectorWriteOnly(PropertyEditor pe, String buttonText) { this(pe, buttonText, pe.getTags()); }
  public PropertySelectorWriteOnly(PropertyEditor pe, String[] tags) { this(pe, "set", tags); }
  public PropertySelectorWriteOnly(PropertyEditor pe, String buttonText, String[] tags) {
    editor = pe;

    setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
    
    c = new Choice();
    for (int i = 0; i < tags.length; i++) c.addItem(tags[i]);
    add(c);

    b = new Button(buttonText);
    add(b);
    b.addActionListener(this);
  }

  private PropertyEditor editor;
  private Choice c;
  private Button b;

  public void actionPerformed(ActionEvent e) {
    String s = c.getSelectedItem();
    editor.setAsText(s);
  }
}
*/
