/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;

public class PropertyFileName extends Container implements ActionListener {
  public PropertyFileName(PropertyEditor pe) { this(pe, "choose..."); }
  public PropertyFileName(PropertyEditor pe, String buttonText) {
    editor = pe;
    
    setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
    
    t = new TextField();
    t.setText(editor.getAsText());
    add(t);
    
    b = new Button(buttonText);
    add(b);
    b.addActionListener(this);
  }
  
  private PropertyEditor editor;
  private TextField t;
  private Button b;
  
  public void actionPerformed(ActionEvent e) {
    File f = new File(editor.getAsText());
    FileDialog fd = new FileDialog(getFrame(), "FileName?", FileDialog.LOAD);
    fd.setDirectory(f.getParent());
    fd.setFile(f.getName());
    fd.setVisible(true);
    String file = fd.getDirectory() + fd.getFile();
    System.out.println("test : " + file instanceof String);
    editor.setAsText(file);
  }
  
  private java.awt.Frame getFrame() {
    Component c = this;
    while(true) {
      c = c.getParent();
      if(c instanceof java.awt.Frame) return (java.awt.Frame) c;
    }
  }
  
  public void repaint() {
    t.setText(editor.getAsText());
  }
}
