/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import opale.soya.*;
import opale.soya.util.*;
import java.beans.*;
import java.lang.reflect.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Hashtable;
import java.util.Vector;
import java.util.Arrays;
import java.util.Comparator;

/**
 * A bean editor.
 * 
 * This bean editor also edits write only properties.
 * 
 * @author Artiste on the Web
 */

public class BeanEditor extends Frame {
  public BeanEditor() {
    super("Properties - <initializing...>");
    
    pane = new BeanEditorPane();
    add(pane);

    addWindowListener(new WindowAdapter() {
      public void windowOpened(WindowEvent e) {
        setDefaultSize();
        doLayout();
        if((customizer != null) && (customizer instanceof Container)) ((Container) customizer).doLayout();
      }
      public void windowClosing(WindowEvent e) {
        Component co = getFocusOwner();
        if(co != null) { // (try to) update the last change.
          co.transferFocus(); 
          requestFocus();
          if(co instanceof FocusListener) ((FocusListener) co).focusLost(new FocusEvent(co, FocusEvent.FOCUS_LOST));
        }
        dispose();
      }
    });
  }
  public BeanEditor(Object bean) {
    this();
    setBean(bean);
  }
  public BeanEditor(Object bean, Customizer cust) {
    this();
    setBean(bean);
    setCustomizer(cust);
  }
  
  private static final int maxHeight, maxWidth;
  static {
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    maxWidth  = d.width ;
    maxHeight = d.height - 70;
  }
  public void doLayout() {
    Insets i = getInsets();
    int width = getWidth() - i.left - i.right, height = getHeight() - i.top - i.bottom;
    if(customizer == null) pane.setBounds(i.left, i.top, width, height);
    else {
      int cheight = customizer.getPreferredSize().height;
      customizer.setBounds(i.left, i.top, width, cheight);
      pane.setBounds(i.left, i.top + cheight, width, height - cheight);
    }
    //pane.doLayout();
  }
  public void setDefaultSize() {
    Insets i = getInsets();
    Dimension p = pane.getPreferredSize();
    Dimension c = null;
    if(customizer == null) c = new Dimension(0, 0);
    else c = customizer.getPreferredSize();
    
    int width = Math.max(p.width, c.width) + i.left + i.right;
    
    int height = p.height + c.height + i.top  + i.bottom;
    if(width  > maxWidth) width  = maxWidth;
    if(height > maxHeight) height = maxHeight;
    setSize(width, height);
  }
  public Dimension getDefaultSize() {
    Insets i = getInsets();
    Dimension p = pane.getPreferredSize();
    Dimension c = null;
    if(customizer == null) c = new Dimension(0, 0);
    else c = customizer.getPreferredSize();
    
    int width = Math.max(p.width, c.width) + i.left + i.right;
    
    int height = p.height + c.height + i.top  + i.bottom;
    if(width  > maxWidth) width  = maxWidth;
    if(height > maxHeight) height = maxHeight;
    return new Dimension(width, height);
  }
  
  private BeanEditorPane pane;
  
  public void edit(Object bean) {
    BeanInfo bi;
    try { bi = Introspector.getBeanInfo(bean.getClass()); }
    catch (IntrospectionException e) { 
      System.out.println("PropertySheet: Couldn't introspect."); e.printStackTrace();
      return;
    }
    pane.setBean(bean, bi);
    
    setTitle("Properties - " + bean.getClass().getName());
    //setDefaultSize();
    Dimension d = getDefaultSize(), d2 = getSize();
    if((d.width > d2.width) ||(d.height > d2.height))setSize(d);
    doLayout();
  }
  public void setBean(Object bean) {
    BeanInfo bi;
    try { bi = Introspector.getBeanInfo(bean.getClass()); }
    catch (IntrospectionException e) { 
      System.out.println("PropertySheet: Couldn't introspect."); e.printStackTrace();
      return;
    }
    try {
      Class customizerClass = bi.getBeanDescriptor().getCustomizerClass();
      if(customizerClass != null) {
        Customizer customizer = (Customizer) customizerClass.newInstance();
        customizer.setObject(bean);
        setCustomizer(customizer);
      }
    }
    catch (Exception e) { System.out.println("PropertySheet: Couldn't create customizer."); e.printStackTrace(); }
    pane.setBean(bean, bi);
    
    //setDefaultSize();
    setTitle("Properties - " + bean.getClass().getName());
  }
  
  private Component customizer;
  public void setCustomizer(Customizer c) {
    if(customizer != null) {
      customizer.removePropertyChangeListener(pane);
      if(customizer instanceof java.awt.Window) ((java.awt.Window) customizer).setVisible(false);
      else remove(customizer);
    }
    customizer = (Component) c;
    if(customizer != null) {
      customizer.addPropertyChangeListener(pane);
      if(customizer instanceof java.awt.Window) ((java.awt.Window) customizer).setVisible(true);
      else {
        setLayout(new GridLayout(2, 1));
        add(customizer);
      }
    }
    else setLayout(new GridLayout(1, 1));
    doLayout();
  }
}
