/*
 * Soya3D
 * Copyright (C) 1999  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.awt;

import opale.soya.*;
import opale.soya.font.*;
import gl4java.*;

class SoftwareTextOverlay extends TextOverlay {
  SoftwareTextOverlay(RenderingSurface rs) { super(rs); } // not public.
  
  public boolean isHardware() { return false; }
  
  private static final int INSET = 3;
  public void draw(GLFunc gl, GLUFunc glu) {
    if(visible) {
      String s = getText();
      Font2D f = getFont();
      if((s != null) && (f != null)) {
        updateDrawPosition();
        float[] b = getBackgroundColor();
        if(b[3] > 0f) { // Has a background.
          if(b[3] < 1f) gl.glEnable(GLEnum.GL_BLEND);
          gl.glColor4fv(b);
          gl.glBegin(GLEnum.GL_QUADS);
          gl.glVertex2f(drawLeft - INSET, drawTop - INSET);
          gl.glVertex2f(drawLeft + drawWidth + INSET, drawTop - INSET);
          gl.glVertex2f(drawLeft + drawWidth + INSET, drawTop + drawHeight + INSET);
          gl.glVertex2f(drawLeft - INSET, drawTop + drawHeight + INSET);
          gl.glEnd();
          if(b[3] < 1f) gl.glDisable(GLEnum.GL_BLEND);
        }
        gl.glColor4fv(getColor());
        f.draw(gl, glu, s, drawLeft, drawTop);
      }
    }
  }
}
