/*
 * Soya3D
 * Copyright (C) 1999  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.awt;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.Renderer;
import gl4java.*;

/**
 * An interface for objects on witch soya can render 3D scenes.
 * 
 * Common rendering surface are RenderingCanvas, RenderingFrame. Also exists
 * RenderingOverlay.
 * 
 * @author Artiste on the Web
 */

public interface RenderingSurface {
  /**
   * Delete the rendering surface. You cannot draw anything in this surface after this
   * method have been called!
   */
  public void dispose();
  
  /**
   * Gets the renderer that renders the 3D on this surface.
   * @return the renderer (commonly a Camera3D).
   */
  public Renderer getRenderer();
  /**
   * Sets the renderer. You must set a renderer before rendering anything.
   * @param r the renderer (commonly a Camera3D).
   */
  public void setRenderer(Renderer r);

  /**
   * @return the width of the surface in pixel.
   */
  public int getSurfaceWidth ();
  /**
   * @return the height of the surface in pixel.
   */
  public int getSurfaceHeight();
  
  public void setVisible(boolean b);
  
  /**
   * Gets the GLContext.
   * @return r the GLContext
   */
  public GLContext getGLContext();
  /**
   * Ensures the GLContext is fully created and avalaible.
   */
  public void createGLContext();

  /**
   * Adds an overlay at this rendering surface.
   * Warning : creating an overlay will add it automatically.
   */
  public void addOverlay(Overlay o);
  /**
   * Remove an overlay from this rendering surface.
   * Warning : use rather Overlay.remove() .
   */
  public void removeOverlay(Overlay o);

  /**
   * Render the 3D. Notice that the rendering is not immediate but done by another thread.
   * This method is equivalent to the repaint() method of java.awt.Canvas .
   */
  public void render();
}
