/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.awt;

import opale.soya.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import gl4java.*;
import gl4java.awt.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * A canvas where you can render 3D scene from a renderer (like a soya.soya3d.Camera3D).
 * 
 * 
 * 
 * @author Artiste on the Web
 */

public class RenderingPanel extends RenderingCanvas implements RenderingMultipleSurface {
  /**
   * Creates a rendering panel with the specified size.
   * @param width  the surface width in pixel
   * @param height the surface height in pixel
   */
  public RenderingPanel(int width, int height) { super(width, height); }
  
  public Renderer getRenderer() { return null; }
  public synchronized void setRenderer(Renderer r) { 
  }
  
  protected java.util.Collection components = new java.util.Vector();
  public void addComponent   (RenderingPanelComponent c) {
    components.add   (c);
  }
  public void removeComponent(RenderingPanelComponent c) {
    components.remove(c);
  }
  public int getNumberOfComponents() { return components.size(); }
  
  /**
   * Draw the 3D scene immediately. You should not use this method but rather render() ,
   * because it is multithreaded.
   */
  public void display() {
    if(glj != null) {
      isRendering = true;
      
      makeCurrent();
      
      if(sizeChanged) {
        GLFunc gl = glj.getGLFunc();
        Quality.initContext(gl, glu);
      }
      
      for(Iterator i = components.iterator(); i.hasNext(); ) {
        RenderingPanelComponent c = (RenderingPanelComponent) i.next();
        if((components.size() > 1) || c.resized || sizeChanged || (!overlays.isEmpty())) {
          c.makeViewportCurrent(gl);
        }
        c.render(gl, glu);
      }
      
      if(!overlays.isEmpty()) {
        if((components.size() > 1)  || sizeChanged) gl.glViewport(0, 0, getWidth(), getHeight());
        Quality.makeOverlaysCurrent(gl, glu, this);
        for(Iterator i = overlays.iterator(); i.hasNext(); ) ((Overlay) i.next()).draw(gl, glu);
        Quality.unmakeOverlaysCurrent(gl, glu, this);
      }
      
      makeSwap();
      
      isRendering = false;
      sizeChanged = false;
    }
  }
  public void render(RenderingPanelComponent c) {
    if(renderer != null && glj != null) {
      isRendering = true;
      
      makeCurrent();
      if(sizeChanged) {
        GLFunc gl = glj.getGLFunc();
        Quality.initContext(gl, glu);
      }
      
      c.render(gl, glu);
      
      if(!overlays.isEmpty()) {
        Quality.makeOverlaysCurrent(gl, glu, this);
        for(Iterator i = overlays.iterator(); i.hasNext(); ) ((Overlay) i.next()).draw(gl, glu);
        Quality.unmakeOverlaysCurrent(gl, glu, this);
      }
      
      makeSwap();
      isRendering = false;
    }
  }
  
  
  // Overlays support :
  private Collection overlays = new java.util.Vector();
  public void addOverlay(Overlay o) {
    if(!overlays.contains(o)) overlays.add(o);
  }
  public void removeOverlay(Overlay o) { overlays.remove(o); }
  
  /**
   * Shows, at the left bottom corner, the FPS (frame per second) rate. It mesures
   * rendering the speed.
   * @return the fps overlay.
   */
  public FPSOverlay showFPS() { return FPSOverlay.newFPSOverlay(this); }
}
