/*
 * Soya3D
 * Copyright (C) 1999  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.awt;

import opale.soya.*;
import opale.soya.soya3d.*;
import gl4java.*;

/**
 * This overlay is a overlayed 3D scene! For example, it is usefull in games for drawing in 3D
 * in the corner of the screen the selected object of weapon.
 * 
 * Use the RenderingSurface interface to define the renderer (commonly a Camera3D). If you want
 * to draw tranparently, set the getRenderer().getOptimization.dontClearFrameBuffer to true. You
 * can also use an alpha blended background image in the drawn environment (see 
 * soya.soya3d.Environment.setBackgroundImage(Image)).
 *
 * Warning : this class doesn't fully implements RenderingSurface : overlays are not supported;
 * the following methods are not implemented :
 *   protected void addOverlay(Overlay)
 *   protected void removeOverlay(Overlay)
 * It is rather useless to add an overlay into another!
 *
 * @author Artiste on the Web
 */

public class RenderingOverlay extends Overlay implements RenderingSurface {
  /**
   * Creates a new rendering overlay, over the given rendering surface.
   * @param rs the given surface
   */
  public RenderingOverlay(RenderingSurface rs) { super(rs); }
  /**
   * Creates a new rendering overlay, over the given rendering surface and for the given renderer.
   * @param rs the given surface
   * @param r the renderer
   */
  public RenderingOverlay(RenderingSurface rs, Renderer r) {
    this(rs);
    renderer = r;
  }
  
  /**
   * Rendering overlays can't be hardwared.
   * @return false
   */
  public boolean isHardware() { return false; }
  
  
  private Renderer renderer;
  /**
   * Gets the renderer.
   * @return the renderer
   */
  public Renderer getRenderer() { return renderer; }
  /**
   * Sets the renderer.
   * @param the new renderer
   */
  public void setRenderer(Renderer c) {
    renderer = c;
    renderer.setRenderingSurface(this);
  }
  
  public void draw(GLFunc gl, GLUFunc glu) {
    if(getVisible()) render(gl, glu);
  }
  
  /**
   * Render the 3D overlay.
   */
  public void render() {
    GLContext c = getRenderingSurface().getGLContext();
    render(c.getGLFunc(), c.getGLUFunc());
  }
  /**
   * Render the 3D overlay.
   * @param gl  the gl for drawing
   * @param glu the glu for drawing
   */
  public void render(GLFunc gl, GLUFunc glu) {
    //System.out.println("viewport : " + drawLeft + " " + drawTop + " " + drawWidth + " " + drawHeight);
    
    updateDrawPosition();
    
    gl.glViewport(drawLeft, drawTop, drawWidth, drawHeight);
    if(renderer != null) renderer.render();
    gl.glViewport(0, 0, renderingSurfaceWidth, renderingSurfaceHeight); // Resets the viewport to normal default.
  }
  
  public void createGLContext() { getRenderingSurface().createGLContext(); }
  public GLContext getGLContext() { return getRenderingSurface().getGLContext(); }
  public void dispose() { remove(); }
  
  /** Not supported */
  public void addOverlay(Overlay o) {  }
  /** Not supported */
  public void removeOverlay(Overlay o) {  }
  
  public int getSurfaceWidth () { return drawWidth ; }
  public int getSurfaceHeight() { return drawHeight; }
}
