/*
 * Soya3D
 * Copyright (C) 1999  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.awt;

import opale.soya.*;
import opale.soya.font.*;
import gl4java.*;

/**
 * An Overlay that shows the number of frames per second.
 * 
 * The value is the averrage FPS of the ten last rendering.
 * 
 * Warning : The first ten values are not significative.
 * 
 * @author Artiste on the Web
 */

public class FPSOverlay extends SoftwareTextOverlay {
  private FPSOverlay(RenderingSurface rs) {
    super(rs);
    setFont(DefaultFont2D.HELVETICA_10);
    setBackgroundColor(.3f, .3f, .3f);
    
    move(-.97f, -.97f);
  } // not public.
  
  /**
   * Creates and returns a new FPS overlay, for the given rendering surface.
   * @param rs the rendering surface
   */
  public static FPSOverlay newFPSOverlay(RenderingSurface rs) { // No support for hardware overlay at this time.
    // TODO : try hardware overlay here.
    return new FPSOverlay(rs);
  }

  private long[] lastTimes = new long[10];
  
  // Overrides :
  public void draw(GLFunc gl, GLUFunc glu) {
    int max = lastTimes.length - 1;
    System.arraycopy(lastTimes, 1, lastTimes, 0, max);
    lastTimes[max] = System.currentTimeMillis();
    float fps = 1000f * ((float) lastTimes.length) / ((float) (lastTimes[max] - lastTimes[0]));
    
    super.setText(Float.toString(fps) + " FPS");
    super.draw(gl, glu);
  }
  
  /**
   * Do nothing. The text is automatically set.
   */
  public void setText(String s) {  } // Disable text-changing.
}
