package opale.soya.aq;

import opale.soya.util.*;
import opale.soya.soya3d.*;
import java.lang.Math;

/**
 * Tests quaternion functions.
 * 
 * @author Artiste on the Web
 */

public class TestQuaternion {
	public static void main(String[] args) {
		System.out.println("testing matrixFromQuaternion, quaternionFromRotation and matrixRotate...");
		for(int i = 0; i < 100; i++) test0();
    
		System.out.println("testing matrixFromQuaternion and quaternionFromMatrix...");
		for(int i = 0; i < 100; i++) test1();
    
		System.out.println("testing quaternionFromGraphical...");
		for(int i = 0; i < 100; i++) test2();
  }
  public static void test0() {
    float angle = rnd() * 360f;
    Vector v = new Vector(rnd(), rnd(), rnd());
    v.normalize();
    float[] matrix  = Matrix.matrixRotate(angle, v.getX(), v.getY(), v.getZ());
    float[] q1 = Quaternion.quaternionFromMatrix(matrix);
    
    float[] vxyz = { v.getX(), v.getY(), v.getZ() };
    float[] q2 = Quaternion.quaternionFromRotation(vxyz, angle);
    
    System.out.println(Quaternion.quaternionEqual(q1, q2));
  }  
  public static void test1() {
    float angle = rnd() * 360f;
    Vector v = new Vector(rnd(), rnd(), rnd());
    v.normalize();
		float[] matrix = Matrix.matrixRotate(angle, v.getX(), v.getY(), v.getZ());
    
    float angle2 = rnd() * 360f;
    Vector v2 = new Vector(rnd(), rnd(), rnd());
    v2.normalize();
		matrix = Matrix.matrixRotate(matrix, angle2, v2.getX(), v2.getY(), v2.getZ());
    
    float[] matrix2 = Quaternion.matrixFromQuaternion(Quaternion.quaternionFromMatrix(matrix));
    System.out.println(Matrix.matrixEqual(matrix, matrix2));
  }
  public static void test2() {
    World3D w = new World3D();
    Volume3D vol = new Volume3D();
    w.add(vol);
    
    
    float angle = rnd() * 360f;
    Vector v = new Vector(rnd(), rnd(), rnd(), w);
    v.normalize();
    
    vol.rotate(v, angle);
    
		float[] matrix  = (float[]) vol.getMatrix().clone();
    
    vol.setXFactor(-1f);
    
    float[] matrix2 = Quaternion.matrixFromQuaternion(Quaternion.quaternionFromGraphical(vol));
    System.out.println(Matrix.matrixEqual(matrix, matrix2));
  }
	public static float rnd() { return ((float) Math.random()) - 0.5f; }
}
