package opale.soya.aq;

import opale.soya.util.*;
import java.lang.Math;

/**
 * Tests matrix inversions and multiplications. OK if prints only "true".
 * 
 * @author Artiste on the Web
 */

public class TestMatrix {
	public static void main(String[] args) {
		System.out.println("testing matrixInvert...");
		for(int i = 0; i < 100; i++) {
			float[] m = rndMatrix();
			float[] r = Matrix.matrixInvert(Matrix.matrixInvert(m));
			System.out.println(Matrix.matrixEqual(m, r));
		}
    
    float[][] mats = new float[10000][];
		for(int i = 0; i < 10000; i++) {
			mats[i] = rndMatrix();
		}
    long t = System.currentTimeMillis();
		for(int i = 0; i < 10000; i++) {
			float[] r = Matrix.matrixInvert(Matrix.matrixInvert(mats[i]));
		}
    t = System.currentTimeMillis() - t;
    System.out.println("time (ms) for 10000 inversions : " + t);
		
		System.out.println("testing matrixMultiply and matrixInvert...");
		for(int i = 0; i < 100; i++) {
			float[] m = rndMatrix();
			float[] r = Matrix.matrixInvert(m);
			float[] q = Matrix.matrixMultiply(m, r);
			System.out.println(Matrix.matrixEqual(q, Matrix.matrixIdentity()));
		}
    
    t = System.currentTimeMillis();
		for(int i = 0; i < 10000; i++) {
			float[] q = Matrix.matrixMultiply(mats[0], mats[i]);
		}
    t = System.currentTimeMillis() - t;
    System.out.println("time (ms) for 10000 multiplications : " + t);
  }
	public static float[] rndMatrix() {
		float[] m = { rnd(), rnd(), rnd(), 0f,
									rnd(), rnd(), rnd(), 0f,
									rnd(), rnd(), rnd(), 0f,
									rnd(), rnd(), rnd(), 1f  };
    return m;
	}
	public static float rnd() { return ((float) Math.random()) - 0.5f; }
}
