/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.ode.ker;

import opale.tools.*;
import java.util.*;

/**
* Cette classe encapsule des problmes d'ODE  dans le sens o elle contient des rfrences  des instances de type Equation, des instances de type TimeScheme et des instance de type Problem. De plus elle attribue  chacune de ces instances des identifiacteurs (sous forme de String) et elle permet de sauvegarder ou de relire des fichiers de donnes contenant la description de problmes (voir la documentation pour la structure, l'utilisation et la conception de fichiers de donnes).
* @author O.C.
* @version 0.1
*/

public class ODE
{
private Vector lobjet;	//liste des objets (quations, problmes, schmas...)
private static Hashtable objectName,userName; 	//liste des correspondances entre noms des classes des objets et leurs noms utilisateurs ncssaires pour la lecture/ecriture des fichiers de donnes.
private Hashtable id,invId; //liste des identificateurs des objets

/** 
* Constructeur par dfaut. Ce constructeur va chercher la ressource "list_object.cfg" afin de rsoudre les noms utilisateurs doones aux classes des objets graphiques.
* Si ce fichier est introuvable, le programme sort en erreur.
* @since Opale-ODE 0.1
*/
public ODE()
	{
	lobjet = new Vector(10,10);
	id = new Hashtable();
	invId = new Hashtable();

	objectName = new Hashtable();
	userName = new Hashtable();
	int type;
	String nomClasse="", nomUser="";
	
	try
	{
	java.io.InputStream in = getClass().getResourceAsStream("name.rsc");
	RFile rf=null;
	if (in != null)
		rf = new RFile(in);
	else
		{
		System.err.println("Fichier name.rsc introuvable.");
		System.err.println("Arret anormal.");
		System.exit(-1);
		}
	type = rf.next();
	while(type != RFile.RF_EOF)
		{
		if (type == RFile.RF_DOUBLE)
			nomClasse = Double.toString(rf.dval);
		else if (type == RFile.RF_STRING)
			nomClasse = rf.sval;
		type = rf.next();
		if (type == RFile.RF_DOUBLE)
			nomUser = Double.toString(rf.dval);
		else if (type == RFile.RF_STRING)
			nomUser = rf.sval;
		else if (type == RFile.RF_EOF)
			{
			System.err.println("Erreur  la lecture du fichier de configuration");
			System.exit(-1);
			}
		
		objectName.put(nomUser,nomClasse);
		userName.put(nomClasse,nomUser);
		type = rf.next();
		}
	}
	catch(java.io.IOException e)
		{
		System.err.println("Erreur  la lecture du fichier de configuration");
		System.err.println(e);
		System.exit(-1);
		}
	//System.err.println(objectName);
	//System.err.println(userName);

	}
	
/**
* Nettoie l'instance courante  en la vidant des objets.
* @since Opale-ODE 0.1
*/	
public void clean()
	{
	lobjet.clear();
	id.clear();
	invId.clear();
	}	
	
/**	
* Supprime un objet de type Equation, probleme ou TimeScheme.
* @param ObjectODE obj, l'objet  supprimer.
* @return int, -1 si addition impossible, 0 sinon.
* @since Opale-ODE 0.1
*/
public int remove(ObjectODE obj)
	{
	if ( lobjet.contains(obj) )	
		{
		Debug.print("dans ODE : ",lobjet);
		lobjet.remove(obj);
		id.remove(getId(obj));
		invId.remove(obj);
		Debug.print("dans ODE : ",lobjet);
		return 0;
		}
	else
		return -1;
	}

/**
* Ajoute un objet  la liste si l'id est libre et l'objet non dj insr.
* @param ObjectODE ob, l'objet  ajouter.
* @param String s, l'id de l'objet.
* @return int, -1 si addition impossible, 0 sinon.
* @since Opale-ODE 0.1
*/
public int add(ObjectODE ob,String s)
	{
	if ( (!contains(s)) && (!contains(ob)) )
		{
		lobjet.add(ob);
		id.put(s,ob);
		invId.put(ob,s);
		Debug.print("Dans ODE: ",id);
		return 0;
		}
	else
		return -1;
	}

/**
* Renvoie l'element  la position spcifie dans le vecteur.
* @param int i la position de l'objet  retourner..
* @return ObjectODE, l'objet retourn
* @since Opale-ODE 0.1
*/
public ObjectODE getObject(int i)
	{
	return (ObjectODE) lobjet.get(i);
	}

/**
* Retourne la taille de la liste des objets.
* @return int, le nombre d'objets dans la liste.
* @since Opale-ODE 0.1
*/	
public int size()
	{
	return lobjet.size();
	}
	
/**
* Copie la liste d'objets dans un tableau.
* @param Object[] tab, le tableau qui contiendra les objets.
* @version Opale-ODE 0.1
*/
public void intoTab(Object[] tab)
	{
	lobjet.copyInto(tab);
	}


/**
* Renvoie un tableau de String qui contient tous les noms utilisateurs des
objets graphiques.
* @return String[] le tableau de noms.
* @since Opale-ODE 0.1
*/
public String[] getUserNameObject()
	{
	Object[] lobj = objectName.keySet().toArray();
	String[] list = new String[objectName.size()];
	int i;
	
	for (i=0;i<objectName.size();i++)
		list[i] = (String) lobj[i];
	return list;
	}
	
/**
* Renvoie le nom de la classe d'un objet  ObjectODE  partir de son nom
utilisateur.
* @return String le nom de la classe.
* @param String le nom utilisateur.
* @since Opale-ODE 0.1
*/ 	
public String getNameObject(String username)
	{
	return (String) objectName.get(username);
	}
	
	
/**
* Renvoie le nom utilisateur d'une classe d'un objet Object  partir de son
nom de classe en Java.
* @param String le nom de la classe.
* @return String le nom utilisateur.
* @since Opale-ODE 0.1
*/ 	
public String getUserName(String objname)
	{
	return (String) userName.get(objname);
	}

/**
* Renvoie l'identificateur d'un objet.
* @param ObjectODE, un objet.
* @return String, l'identificateur correspondant.
* @since Opale-ODE 0.1
*/
public String getId(ObjectODE obj)
	{
	return (String) invId.get(obj);
	}
	

	
/**
* Renvoie un id construit automatiquement du style "obj_n" o n est le
nombre d'lment+1.
* @return String, l'id gnr.
* @since Opale-ODE 0.1
*/
public String getLinearId()
	{
	return "obj"+(size());
	}

/**
* Teste si la chaine passe en paramtre est un identificateur utilis.
* @param String id, la chaine a tester.
* @return boolean, true si utilis, false sinon.
* @since Opale-ODE 0.1
*/
public boolean contains(String s)
	{
	return id.containsKey(s);
	}

/**
* Teste si l'objet pass en paramtre est dj stock.
* @param ObjectODE, l'objet  tester.
* @return boolean, true si utilis, false sinon.
* @since Opale-ODE 0.1
*/
public boolean contains(ObjectODE o)
	{
	return invId.containsKey(o);
	}

/**
* Renvoie un objet  partir de son identificateur.
* @param String, l'identificateur correspondant.
* @return ObjectODE, null si l'identificateur ne correspond  aucun objet ; l'objet sinon..
* @since Opale-ODE 0.1
*/
public ObjectODE fromId(String id)
	{
	return (ObjectODE) this.id.get(id);
	}
	

/**
* Lit dans un fichier une liste d'objets.
* @param RFile f, le fichier  lire.
* @since Opale-ODE 0.1
*/
public void readFile(RFile f) throws MalformedFileException
	{
	int type;
	
	try
	{
	type = f.next();
	while (type != RFile.RF_EOF)
		{
			System.err.println("*Lecture d'un objet de type "+f.sval+".");
			if (getNameObject(f.sval) == null) 
				{
				System.err.println("Erreur  la lecture du fichier " + f);
				System.err.println("Impossible d'identifier le type d'objet "+f.sval+".");
				System.exit(-1);
				}	
			ObjectODE ob =  (ObjectODE) Class.forName(getNameObject(f.sval)).newInstance();
			f.next();	//on lit l'id
			String id = f.sval;
			Debug.print("identificateur = ",id);
			ob.readFile(f,this);
			if (add(ob,id) == -1)
				throw new MalformedFileException("Ajout de l'objet "+ob+" impossible. Identifiant "+id+" dj utilis.");
			System.err.println("*Fin de lecture d'un objet.");

			 
		type = f.next();
		}
	}
	catch (java.io.IOException e)
	{
	System.err.println("Erreur  la lecture du fichier " + f);
	System.err.println(e);
	System.exit(-1);
	}	
	catch(ClassNotFoundException exc)
	{
	throw new MalformedFileException("Erreur  la lecture d'un objet de type "+f.sval+" : la classe n'existe pas.");
	}
	catch(IllegalAccessException exc)
	{
	throw new MalformedFileException("Erreur  la lecture d'un objet de type "+f.sval+" : acces  la classe impossible.");
	}
	catch(InstantiationException exc)
	{
	throw new MalformedFileException("Erreur  la lecture d'un objet de type "+f.sval+" : classe non instanciable.");
	}
	}
	

/**
* Ecrit dans un fichier le contenu de cette classe.
* @param WFile f, le fichier dans lequel on veut ecrire.
* @since Opale-ODE 0.1
*/
public void writeFile(WFile f) throws MalformedFileException
	{
	int i;
	
	for (i=0; i<size();i++)
		{
		ObjectODE obj = getObject(i);
		if (!(obj instanceof Problem))
			{
			f.write(getUserName(obj.getClass().getName()));
			f.writeln(getId(obj));
			obj.writeFile(f,this);
			}
		}
	
	for (i=0; i<size();i++)
		{
		ObjectODE obj = getObject(i);
		if ((obj instanceof Problem))
			{
			f.write(getUserName(obj.getClass().getName()));
			f.writeln(getId(obj));
			obj.writeFile(f,this);
			}
		}
	
	}
/**
* Rsoud tous les problmes stocks dans l'objet courant.
* @since Opale-ODE 0.1
*/
public void solve()
	{
	int i;
	ObjectODE obj;
	for (i=0;i<size();i++)
		{
		obj = getObject(i);
		if ((obj instanceof Problem))
			{
			((Problem) obj).solve();
			}
		}
	}
	

}
