/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.ker;

/**
* Classe contenant des informations sur les objets de type Gaxis2D. Elle tend la classe InfoObjet et renseigne donc sur les champs contenus dans cette dernire.
* @author O.C.
* @version 0.1
*/
public class InfoAxis extends InfoObject implements Cloneable
{
private double XtickMin,YtickMax,XtickMax,YtickMin;
/**
* Constructeur par dfaut: XtickMax = YtickMax = 1
*/
public InfoAxis()
	{
	super();
	XtickMax = YtickMax = 1;
	XtickMin = YtickMin = 0.5;
	}

/**
* Le constructeur de copie
* @param InfoAxis inf, l'information  copier
*/
public InfoAxis(InfoAxis inf)
	{
	super(inf);
	XtickMax = inf.XtickMax;
	YtickMax = inf.YtickMax;
	XtickMin = inf.XtickMin;
	YtickMin = inf.YtickMin;
	}


//methodes d'accs, publiques

/**
* Renvoie la valeur de l'espacement max des tirets sur l'axe des X.
* @return double, le pas en X.
* @since Opale 0.1
*/
public double getXtickMax()
	{
	return XtickMax;
	}

/**
* Renvoie la valeur de l'espacement max des tirets sur l'axe des Y.
* @return double, le pas en Y. 
* @since Opale 0.1
*/
public double getYtickMax()
	{
	return YtickMax;
	}

/**
* Renvoie la valeur de l'espacement min des tirets sur l'axe des X.
* @return double, le pas en X.
* @since Opale 0.1
*/
public double getXtickMin()
	{
	return XtickMin;
	}

/**
* Renvoie la valeur de l'espacement min des tirets sur l'axe des Y.
* @return double, le pas en Y. 
* @since Opale 0.1
*/
public double getYtickMin()
	{
	return YtickMin;
	}

/**
* Fixe les valeurs des espacements des tirets sur les axes X et Y.
* @param double xm, espacement minimale sur X.
* @param double xM, espacement maximale sur X.
* @param double ym, espacement minimale sur Y.
* @param double yM, espacement maximale sur Y.
* @since Opale 0.1
*/
public void setTick(double xm, double xM, double ym, double yM)
	{
	if ( xm <= xM )
		{
		XtickMin = xm;
		XtickMax = xM;
		}
	else
		{
		XtickMin = xM;
		XtickMax = xm;
		}
	if ( ym <= yM )
		{
		YtickMin = ym;
		YtickMax = yM;
		}
	else
		{
		YtickMin = yM;
		YtickMax = ym;
		}
	}
		
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
* @since Opale 0.1
*/
public Object clone()
	{
	try
	{
	return (InfoAxis) super.clone();
    }
	catch(InternalError e)
	{
	throw e;
	}
	}

}

