/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.ker;

/**
* Classe abstraite qui modlisent un systme de coordonnes quelconque.
* Il faut tendre cette classe en une classe instanciable pour crer un systme de coordonnes comme 
* un systme de coordonnes cartsien, polaire, Log-Log...
* @author O.C.
* @version 0.1
*/

abstract public class CoordSystem
{
protected double xmin,ymin,xmax,ymax; //bornes du repre
protected int width,height,borderX,borderY; //coordones relles 'ecran'
protected OIJ oij;


public CoordSystem() 
	{
	this.xmin=this.ymin=-10;
	this.xmax=this.ymax=+10;
	}
/**
* fixe le repre OIJ
* @param OIJ, le repre.
* @since Opale 0.1
*/
public void setOIJ(OIJ oij)
	{
	this.oij = oij;
	}
	
/**
* Renvoie le repre OIJ.
*return OIJ le repre.
* @since Opale 0.1
*/	
public OIJ getOIJ()
	{
	return oij;
	}
/**
* Cette mthode ajuste automatiquement le repre en fonction des dimensions 'ecrans' et des bornes du repre utilisateur.
* @since Opale 0.1
*/
abstract public void autoadjust();

/**
* Cette mthode ajuste  le repre en fonction des dimensions 'ecrans' et des bornes du repre utilisateur afin de conserver les normes.
* @since Opale 0.1
*/
abstract public void normadjust();


/**
* Cette mthode renvoie l'abscisse relle dans la feuille  partir des coordonnes au repre utilisateur.
* @param double x, double y les coordonnes utilsateurs( ATTENTION: pas forcment coordonnes cartsiennes mais dpend de l'implementation du systme de coordonnes)
* @return int, la coordonne relle sur l'ecran 
* @since Opale 0.1
*/
abstract public int X(double x, double y);

/**
* Cette mthode renvoie l'ordonne relle dans la feuille  partir des coordonnes au repre utilisateur.
* @param double x, double y les coordonnes utilsateurs( ATTENTION: pas forcment coordonnes cartsiennes mais dpend de l'implementation du systme de coordonnes)
* @return int, la coordonne relle sur l'ecran 
* @since Opale 0.1
*/
abstract public int Y(double x, double y);

/**
* Renvoie la premire coordonne utilisateur  partir de l'abscisse relle
* @param int X, int Y, coordonnes relles
* @return double, premire coodrdonne utilisateur
* @since Opale 0.1
*/
abstract public double xfromXY(int X, int Y);

/**
* Renvoie la deuxime coordonne utilisateur  partir de l'abscisse relle
* @param int X, int Y, coordonnes relles
* @return double, deuxime coodrdonne utilisateur
* @since Opale 0.1
*/
abstract public double yfromXY(int X, int Y);

/**
* Renvoie le carre de la norme du vecteur(x,y) dans le systeme en question.
* @param double x, double y, les coordonnes du vecteur.
* @return double, la norme du vecteur.
* since Opale 0.1
*/
abstract public double normSq(double x, double y);



//mthodes implmentes
/**
* change xmin
*  @param double xmin, la nouvelle valeur
*  @return 0 si tout va bien, -1 sinon
*/
final public int setXmin(double xmin)
	{
	if (xmin < xmax)
		{
		this.xmin=xmin;
		return 0;
		}
	else
		return -1;
	}


/**
* change ymin
* @param double ymin, la nouvelle valeur
* @return 0 si tout va bien, -1 sinon
*/
final public int setYmin(double ymin)
	{
	if (ymin < ymax)
		{
		this.ymin=ymin;
		return 0;
		}
	else
		return -1;
	}

/**
* change xmax
* @param double xmax, la nouvelle valeur
* @return 0 si tout va bien, -1 sinon
*/
final public int setXmax(double xmax)
	{
	if (xmin < xmax)
		{
		this.xmax=xmax;
		return 0;
		}
	else
		return -1;
	}

/**
* change ymax
* @param double ymax, la nouvelle valeur
* @return 0 si tout va bien, -1 sinon
* @since Opale 0.1
*/
final public int setYmax(double ymax)
	{
	if (ymin < ymax)
		{
		this.ymax=ymax;
		return 0;
		}
	else 
		return -1;
	}

/**
* change les bornes d'affichage
* @param double xmin, xmax, ymin, ymax les nouvelles bornes
* @return 0 si tout va bien, -1 sinon
* @since Opale 0.11
*/
final public int set(double xmin, double xmax, double ymin, double ymax)
	{
	if ( (ymin < ymax) && (xmin < xmax) )
		{
		this.xmax=xmax;
		this.ymax=ymax;
		this.ymin=ymin;
		this.xmin=xmin;
		return 0;
		}
	else 
		return -1;
	}


/**
* renvoie la valeur actuelle de xmin
* @return double xmin
* @since Opale 0.1
*/
final public double getXmin()
	{
	return xmin;
	}

/**
* renvoie la valeur actuelle de ymin
* @return double ymin
* @since Opale 0.1
*/
final public double getYmin()
	{
	return ymin;
	}


/**
* renvoie la valeur actuelle de xmax
* @return double xmax
* @since Opale 0.1
*/
final public double getXmax()
	{
	return xmax;
	}


/**
* renvoie la valeur actuelle de ymax
* @return double ymax
* @since Opale 0.1
*/
final public double getYmax()
	{
	return ymax;
	}

/**
* fixe les dimensions de la feuille de dessin
* @param int x, int y, les coordonnes suprieures gauches.
* @param int width, int height, la largeur et la hauteur.
* @since Opale 0.1
*/
final public void setSize(int x, int y, int width, int height)
	{
	if ( (width > 0) && (height>0) && (x>=0) && (y>=0) )
		{
		this.width=width;
		this.height=height;
		borderX=x;
		borderY=y;
		}
	}

/**
* Renvoie la largeur de la feuille.
* @return int w, la largeur.
* @since Opale 0.1
*/
public int getWidth()
	{
	return width;
	}

/**
* Renvoie la hauteur de la feuille.
* @return int h, la hauteur.
* @since Opale 0.1
*/
public int getHeight()
	{
	return height;
	}

/**
* Renvoie l'abscisse du coin suprieur gauche de la feuille.
* @return int, l'abscisse.
* @since Opale 0.1
*/
public int getXinf()
	{
	return borderX;
	}

/**
* Renvoie l'ordonne du coin suprieur gauche de la feuille.
* @return int, l'ordonne.
* @since Opale 0.1
*/
public int getYinf()
	{
	return borderY;
	}
	
/**
* teste si un point (x,y) appartient  la zone (xmin,xmax,ymin,ymax)
*  @param double x,y, les coordonnes du point  tester
*  @return boolean, true si le point appartient, false sinon
*/
public boolean test(double x, double y)
	{
	return ( (x >= xmin) && (x <= xmax) && (y >= ymin) && (y<=ymax) );
	}


}