#!/bin/sh

if [ -z "$OPALE_DIR" ]
then
	echo "La variable OPALE_DIR n'est pas initialise !"
	exit -1
fi

usage() {
	echo "Il faut prciser le repertoire de destination !"
	echo "Usage : makearch.sh destination"
	exit -1
	}
	
[ -z "$1" ] && usage

echo "Compilation de toutes les classes opale"
echo "Rsultat dans le rpertoire" $1

javac=javac

#Compilation de opale/tools
echo "compilation de opale.tools"
javac  -d $1 $OPALE_DIR/opale/tools/*.java

#Compilation de opale/swools
echo "compilation de opale.swools"
javac  -d $1 $OPALE_DIR/opale/swools/*.java

#Compilation de opale/mathtools
echo "compilation de opale.mathtools"
javac  -d $1 $OPALE_DIR/opale/mathtools/*.java

#Compilation de opale/ode
echo "compilation de opale.ode"
javac  -d $1 $OPALE_DIR/opale/ode/ker/*.java
javac  -d $1 $OPALE_DIR/opale/ode/scheme/*.java
cp -rf $OPALE_DIR/opale/ode/ker/name.rsc $1/opale/ode/ker

#Compilation de opale/m2d
echo "compilation de opale.m2d"
javac  -d $1 $OPALE_DIR/opale/m2d/ker/*.java
javac  -d $1 $OPALE_DIR/opale/m2d/object2d/*.java
javac  -d $1 $OPALE_DIR/opale/m2d/component2d/*.java
cp -rf $OPALE_DIR/opale/m2d/ker/list_object.cfg $1/opale/m2d/ker

echo "Cration de l'archive opale.jar"
cd $1
jar cvf opale.jar opale
