/*
 * Decompiled with CFR 0.152.
 */
package opale.ode.ker;

import java.io.IOException;
import opale.mathtools.DVect;
import opale.ode.ker.Equation;
import opale.ode.ker.MalformedFileException;
import opale.ode.ker.ODE;
import opale.ode.ker.ObjectODE;
import opale.ode.ker.Problem;
import opale.tools.RFile;
import opale.tools.WFile;

public abstract class TimeScheme
extends ObjectODE {
    private double tinit = 0.0;
    private double tmax = 1.0;
    private double tc;
    private double dt;
    private int Nstep = 11;
    private Problem pb = null;
    private DVect present;

    public abstract void forward(Equation var1);

    public final DVect present() {
        return this.present;
    }

    public final void set(double d, double d2) {
        this.tinit = Math.min(d, d2);
        this.tmax = Math.max(d, d2);
    }

    public final void setNstep(int n) {
        this.Nstep = Math.max(3, Math.abs(n));
    }

    public final int getNstep() {
        return this.Nstep;
    }

    public final void setPb(Problem problem) {
        this.pb = problem;
    }

    public final Problem getPb() {
        return this.pb;
    }

    public final double tmin() {
        return this.tinit;
    }

    public final double tmax() {
        return this.tmax;
    }

    public final double dt() {
        return this.dt;
    }

    public final double time() {
        return this.tc;
    }

    public void init() {
        if (this.pb == null) {
            System.err.println("Le sch\u00e9ma n'est associ\u00e9 \u00e0 aucun probl\u00e8me.\nArret anormal du calcul.");
            System.exit(-1);
        }
        this.present = new DVect(this.pb.dim());
        this.present.set(this.pb.getInit());
        this.dt = (this.tmax - this.tinit) / (double)(this.Nstep - 1);
        this.tc = this.tinit;
    }

    public void update() {
        this.tc += this.dt;
    }

    public int readKeyWord(String string, RFile rFile, ODE oDE) throws IOException, MalformedFileException {
        if (string.equals("N")) {
            int n = rFile.next();
            this.Nstep = (int)rFile.dval;
            return 0;
        }
        if (string.equals("tmin")) {
            int n = rFile.next();
            if (n != RFile.RF_DOUBLE) {
                return -1;
            }
            this.tinit = rFile.dval;
            return 0;
        }
        if (string.equals("tmax")) {
            int n = rFile.next();
            if (n != RFile.RF_DOUBLE) {
                return -1;
            }
            this.tmax = rFile.dval;
            return 0;
        }
        return -1;
    }

    public void writeFile(WFile wFile, ODE oDE) {
        wFile.writeln("{");
        wFile.writeln("tmin " + this.tinit);
        wFile.writeln("tmax " + this.tmax);
        wFile.writeln("N " + this.Nstep);
        wFile.writeln("}");
    }
}

