/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.module2d.noyau2d;

/**
* Cette classe reprsente la lgende attach  une instance de Pack2D. Elle permet de dessiner les lgendes de tous les objets contenus dans le pack  et qui acceptent les lgendes.
* @author O.C.
* @version 0.11
*/
public final class Legend
{
private Pack2D pack;
private double x, y;
private boolean visible;

public Legend(Pack2D pack)
	{
	super();
	this.pack = pack;
	visible = false;
	}

public final void setVisible(boolean b)
	{
	visible = b;
	}
	
public final void setLocation(int x, int y)
	{
	this.x = x;
	this.y = y;
	}
	
public final double getX()
	{
	return x;
	}
	
public final double getY()
	{
	return y;
	}
	
public final void draw(Pen2D c)
	{
	if ( visible)
	{
	int i;
	ILegend temp;
	double yy=5;
	int X0 = (int) (x*(c.getCoordSyst().getXmax()-c.getCoordSyst().getXmin()));
	int Y0 = (int) (y*(c.getCoordSyst().getYmax()-c.getCoordSyst().getYmin()));
	
	double x0 ,y0;
	
	for(i=0;i<pack.sizeObject();i++)
		{
		if (pack.getObject(i) instanceof ILegend)
			{
			temp = (ILegend)pack.getObject(i);
			if ( temp.getLegend() != null)
				{
				x0 = c.getCoordSyst().xfromXY(X0,Y0);
				y0 = c.getCoordSyst().yfromXY(X0,Y0);
				temp.drawLegend(c,x0,y0,30,10);
				c.drawString(temp.getLegend(),x0,y0,35,5);
				Y0+=25;
				}
			}
		}
	}
	}
	
//readFile(...)
//writeFile(...)
}
