/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.module2d.noyau2d;
import opale.tools.*;

/**
* Cette classe abstraite est  tendre par toutes les classes designant un objet gomtrique 2D.
* @author OC
* @version 0.1
*/
public abstract class Object2D implements Cloneable
{
private OIJ rep;	//Tout objet 2d est dfini dans un repre OIJ.

/**
* Constructeur par dfaut.
* @since Opale 0.1
*/
public Object2D()
	{
	this.rep = new OIJ();
	}
	
/**
* Constructeur par dfaut avec spcification du repre.
* @param OIJ rep, le repre  attacher.
* @since Opale 0.1
*/
public Object2D(OIJ rep)
	{
	this.rep = rep;
	}

/**
* Permet de changer le repre de dfinition de l'objet.
* @param OIJ rep, le nouveau repre.
* @since Opale 0.1
*/
public void setOIJ(OIJ rep)
	{
	this.rep = rep;
	}
	
	
/**
* Renvoie le repre de dfinition de l'objet.
* @return OIJ rep, le repre.
* @since Opale 0.1
*/
public OIJ getOIJ()
	{
	return rep;
	}
	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
* @since Opale 0.1
*/
public Object clone()
	{
	try
		{
		Object2D obj = (Object2D) super.clone();
		obj.rep = rep;
		return obj;
		}
	catch (CloneNotSupportedException e) // ne devrait jamais arriver
		{
		throw new InternalError();
		}
    }

/**
* Lit dans un fichier les donnes relatifs  un objet en invoquant la mthode
readKeyWord()
* @param RFile f, le fichier  lire.
* @prama Pack2D p, le pack2D qui contient les objets courants.
* @since Opale 0.1
*/
public void readFile(RFile f,Pack2D pack) throws java.io.IOException,MalformedFileException
	{
	int type;
	OIJ lerepere=null;

	type = f.next();	//on lit la premiere '{'
	if ( (type !=RFile.RF_STRING) || !f.sval.equals("{") ) throw new MalformedFileException("Fichier de donnes au mauvais format !!");
	type = f.next();	
	do
		{
		if (type != RFile.RF_STRING)  throw new MalformedFileException("Fichier de donnes au mauvais format : on attend un mot cl !!");
		if ((f.sval).equals("OIJ"))
			{
			type =f.next();
			if (type != RFile.RF_STRING) throw new MalformedFileException("Fichier de donnes au mauvais format : erreur  la lecture d'un repre");
			System.out.println("Dans Object2D : "+pack.contains(f.sval));
			System.out.println("Dans Object2D : "+pack.OIJfromId(f.sval));
			if ( (!pack.contains(f.sval)) || (pack.OIJfromId(f.sval)) == null) throw new MalformedFileException("Fichier de donnes au mauvais format : l'identificateur "+f.sval+" n'existe pas !!");
			lerepere = pack.OIJfromId(f.sval);
			} 
			
		else if (readKeyWord(f.sval,f,pack) == -1) throw new MalformedFileException("Fichier de donnes au mauvais format : erreur de lecture d'un mot cl !!");
		type = f.next();
		}
	while ((type !=RFile.RF_STRING) || !f.sval.equals("}") );

	if (lerepere == null) throw new MalformedFileException("Vous n'avez pas attach de repre  l'objet "+this);
	setOIJ(lerepere);
	
	
	}

	
/**
* Effectue un changement de repre de l'objet.
* @param OIJ le nouveau repre.
* @since Opale 0.1
*/	
public abstract void changeOIJ(OIJ rep);


/**
* Surcharge de toString()
* @since Opale 0.1
*/
public abstract String toString();


/**
* Interprte un mot cl lu dans un fichier.
* @param String word, le mot cl  dcoder.
* @param RFile f, le fichier en cours de lecture.
* @param Pack2D p, le pack qui contient l'ensemble des objets 2d en cours
d'existence.
* @return int, 0 si le mot  t compris, -1 sinon.
* @since Opale 0.1
*/
public abstract int readKeyWord(String word, RFile f,Pack2D pack) throws java.io.IOException, MalformedFileException; 

/**
* Ecris les informations concernant l'objet dans un fichier.
* @param WFile f, le fichier dans lequel il faut crire.
* @since Opale 0.1
*/
public void writeFile(WFile f,Pack2D pack) throws MalformedFileException
	{
	f.writeln("{");
	if (!pack.contains(getOIJ())) throw new MalformedFileException("Erreur  l'criture du fichier : le repre "+getOIJ()+" n'existe pas !!");
	f.writeln("OIJ "+pack.getId(getOIJ()));
	writeFileMore(f,pack);
	f.writeln("}");
	}
		
/**
* Ecris les informations complmentaires concernant l'objet dans un fichier.
* @param WFile f, le fichier dans lequel il faut crire.
* @since Opale 0.1
*/
public abstract void writeFileMore(WFile f,Pack2D pack);

}
