/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.module2d.noyau2d;
import opale.tools.*;

/**
* Cette classe hritent de la classe de base <code>Vector2D</code> et implmente
* l'interface <code>GObject2D</code>
* @author O.C.
* @version 0.1
*/

public class GVector2D extends Vector2D implements GObject2D,Cloneable
{
//membres privs
private InfoVector info; //Info sur le vecteur
private GPoint2D origin;	// l'origine du vecteur ATTENTION:prive car on ne doit pas modifier son repere.

/**
* Constructeur par dfaut.
* @since Opale 0.1
*/
public GVector2D()
	{
	System.out.println("ici dan GVector2D");
	info = new InfoVector();
	origin = new GPoint2D();
	System.out.println("ici dan GVector2D");
	}

/**
* Le constructeur par dfaut
* Construit et initialise le vecteur avec les coomposantes (0; 0) et avec les informations par dfaut.  
* @param OIJ rep, le repre de dfinition du vecteur
* @since Opale 0.1
*/
public GVector2D(OIJ rep)
	{
	super(rep);
	info = new InfoVector();
	origin = new GPoint2D(rep);
	}

/**
* Construit et initialise le vecteur avec les composantes (x; y) et avec les informations par dfaut.  
* @param OIJ rep, le repre de dfinition du vecteur
* @param double x,y les composantes du vecteur.
* @since Opale 0.1
*/
public GVector2D(OIJ rep,double x, double y)
	{
	super(rep,x,y);
	info = new InfoVector();
	origin = new GPoint2D(rep);
	}


/**
* Construit et initialise le vecteur avec un autre vecteur et avec un nom.  
* @param Vector2D v le vecteur  copier.
* @param String nom, le nom de l'objet.
* @since Opale 0.1
*/
public GVector2D(Vector2D v, String nom)
	{
	super(v);
	origin = new GPoint2D(v.getOIJ());
	info = new InfoVector();
	info.setName(nom);
	}

/**
* Le constructeur de copie
* @param GVector2D v, le vecteur  copier
* @since Opale 0.1
*/
public GVector2D(GVector2D v)
	{
	super(v);
	origin = (GPoint2D) v.getOrigin().clone();
	info = new InfoVector((InfoVector) v.getInfo());
	}

public void draw(Pen2D c)
	{
	if (info.isVisible())
		{
		double ox = getOrigin().x;
		double oy = getOrigin().y;
		c.setColor(info.getColor());
		if (info.symbolArrow == 0)
			{
			c.drawLine(ox,oy,ox+x,oy+y);
			c.drawArrow(ox,oy,ox+x,oy+y,info.size);
			}
		((InfoPoint) origin.getInfo()).setSymbol(info.symbol);
		}
	}
	
public InfoObject getInfo()
	{
	return info;
	}
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
* @since Opale 0.1
*/
public Object clone()
	{
	try
		{
		GVector2D v = (GVector2D) super.clone();
		v.info = (InfoVector) info.clone();
		v.origin = (GPoint2D) origin.clone();
		return v;
		}
	catch (InternalError e) // ne devrait jamais arriver
		{
	    	throw e;
		}
    }


/**
* Renvoie un clone de l'origine du vecteur.
* @return GPoint2D l'origine.
* @since Opale 0.1
*/
public GPoint2D getOrigin()
	{
	return (GPoint2D) origin.clone();
	}

/**
* Fixe l'origine du vecteur.
* @param double x,y l'origine.
* @since Opale 0.1
*/
public void setOrigin(double x, double y)
	{
	origin.setLocation(x,y);
	}

/**
* Surcharge de setOIJ(OIJ rep) de Object2D pour changer a la fois le repere du
vecteur et de l'origine.
* @param OIJ rep, le nouveau repere.
* @since Opale 0.1
*/
public void setOIJ(OIJ rep)
	{
	super.setOIJ(rep);
	origin.setOIJ(rep);
	}

/*public void writeFile(WFile f, Pack2D p)
	{
	f.writeln("{");
	f.writeln("Origine "+origin.x+" "+origin.y);
	f.writeln("X " +x);
	f.writeln("Y " +y);
	f.writeln("}");
	}	
*/
/**
* Effectue un changement de repere du vecteur.
* @param OIJ rep, le nouveau repere.
* @since Opale 0.1
*/
public void changeOIJ(OIJ rep)
	{
	origin.changeOIJ(rep);
	super.changeOIJ(rep);
	}
	
	
public int readKeyWord(String word, RFile f, Pack2D p) throws java.io.IOException, MalformedFileException
	{
	if ( word.equals("INFO"))
		{
		info.readFile(f,p);
		return 0;
		}
	else return super.readKeyWord(word,f,p);
	}

public void writeFileMore(WFile f, Pack2D p)
	{
	info.writeFile(f,p);
	f.writeln("ORIGIN "+origin.x+" " +origin.y);
	super.writeFileMore(f,p);
	}	

}

