/*
 * Decompiled with CFR 0.152.
 */
package opale.module2d.object2d;

import java.io.IOException;
import java.util.Vector;
import opale.module2d.noyau2d.MVPass;
import opale.module2d.noyau2d.MalformedFileException;
import opale.module2d.noyau2d.OIJ;
import opale.module2d.noyau2d.Object2D;
import opale.module2d.noyau2d.Pack2D;
import opale.module2d.noyau2d.Point2D;
import opale.module2d.noyau2d.Transformable;
import opale.tools.RFile;
import opale.tools.WFile;

public class Data2D
extends Object2D
implements Transformable,
Cloneable {
    protected double[] x;
    protected double[] y;
    protected int nbPts;

    public Data2D() {
        System.out.println("Dans Data2D()" + this.nbPts);
        this.x = new double[1];
        this.y = new double[1];
    }

    public Data2D(OIJ oIJ) {
        super(oIJ);
        this.x = new double[1];
        this.y = new double[1];
    }

    public Data2D(OIJ oIJ, int n) {
        super(oIJ);
        this.nbPts = Math.abs(n);
        this.x = new double[this.nbPts];
        this.y = new double[this.nbPts];
    }

    public Data2D(Data2D data2D) {
        super(data2D.getOIJ());
        this.nbPts = data2D.nbPts;
        this.x = new double[this.nbPts];
        this.y = new double[this.nbPts];
        int n = 0;
        while (n < this.nbPts) {
            this.x[n] = data2D.x[n];
            this.y[n] = data2D.y[n];
            ++n;
        }
    }

    public Data2D backwardDiff() {
        Data2D data2D = new Data2D(this.getOIJ(), this.nbPts - 1);
        int n = 1;
        while (n < this.nbPts) {
            data2D.x[n] = this.x[n];
            double d = this.x[n] - this.x[n - 1];
            if (d != 0.0) {
                data2D.y[n] = (this.y[n] - this.y[n - 1]) / d;
            }
            ++n;
        }
        return data2D;
    }

    public Data2D centeredDiff() {
        Data2D data2D = new Data2D(this.getOIJ(), this.nbPts - 1);
        int n = 1;
        while (n < this.nbPts - 1) {
            data2D.x[n] = this.x[n];
            double d = this.x[n + 1] - this.x[n - 1];
            if (d != 0.0) {
                data2D.y[n] = (this.y[n + 1] - this.y[n - 1]) / d;
            }
            ++n;
        }
        return data2D;
    }

    public void changeOIJ(OIJ oIJ) {
        MVPass mVPass = new MVPass();
        this.getOIJ().matPassage(oIJ, mVPass);
        int n = 0;
        while (n < this.nbPts) {
            Point2D point2D = mVPass.compute(this.x[n], this.y[n]);
            this.x[n] = point2D.getX();
            this.y[n] = point2D.getY();
            ++n;
        }
        this.setOIJ(oIJ);
    }

    public Object clone() {
        Data2D data2D = (Data2D)super.clone();
        int n = 0;
        while (n < this.nbPts) {
            data2D.x[n] = this.x[n];
            data2D.y[n] = this.y[n];
            ++n;
        }
        return data2D;
    }

    public boolean equals(Object object) {
        if (object instanceof Data2D) {
            Data2D data2D = (Data2D)object;
            boolean bl = false;
            bl = this.nbPts == data2D.nbPts;
            if (bl) {
                int n = 0;
                while (n < this.nbPts) {
                    bl = bl && this.x[n] == data2D.x[n] && this.y[n] == data2D.y[n];
                    ++n;
                }
            }
            return bl && this.getOIJ().equals(data2D.getOIJ());
        }
        return false;
    }

    public Data2D forwardDiff() {
        Data2D data2D = new Data2D(this.getOIJ(), this.nbPts - 1);
        int n = 0;
        while (n < this.nbPts - 1) {
            data2D.x[n] = this.x[n];
            double d = this.x[n + 1] - this.x[n];
            if (d != 0.0) {
                data2D.y[n] = (this.y[n + 1] - this.y[n]) / d;
            }
            ++n;
        }
        return data2D;
    }

    public void readData(RFile rFile) throws IOException {
        Vector<Double> vector = new Vector<Double>(100, 20);
        Vector<Double> vector2 = new Vector<Double>(100, 20);
        int n = rFile.next();
        while (n != RFile.RF_EOF) {
            if (n == RFile.RF_DOUBLE) {
                vector.add(new Double(rFile.dval));
            }
            n = rFile.next();
            vector2.add(new Double(rFile.dval));
            n = rFile.next();
        }
        this.nbPts = vector.size();
        this.x = new double[this.nbPts];
        this.y = new double[this.nbPts];
        Object[] objectArray = new Double[this.nbPts];
        Object[] objectArray2 = new Double[this.nbPts];
        vector.copyInto(objectArray);
        vector2.copyInto(objectArray2);
        int n2 = 0;
        while (n2 < this.nbPts) {
            this.x[n2] = (Double)objectArray[n2];
            this.y[n2] = (Double)objectArray2[n2];
            ++n2;
        }
    }

    public int readKeyWord(String string, RFile rFile, Pack2D pack2D) throws IOException, MalformedFileException {
        if (string.equals("N")) {
            int n = rFile.next();
            if (n != RFile.RF_DOUBLE) {
                return -1;
            }
            this.nbPts = (int)rFile.dval;
            this.x = new double[this.nbPts];
            this.y = new double[this.nbPts];
            return 0;
        }
        if (string.equals("Points")) {
            int n = 0;
            while (n < this.nbPts) {
                int n2 = rFile.next();
                if (n2 != RFile.RF_DOUBLE) {
                    return -1;
                }
                this.x[n] = rFile.dval;
                n2 = rFile.next();
                if (n2 != RFile.RF_DOUBLE) {
                    return -1;
                }
                this.y[n] = rFile.dval;
                ++n;
            }
            return 0;
        }
        return -1;
    }

    public void rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        int n = 0;
        while (n < this.nbPts) {
            double d4 = this.x[n];
            this.x[n] = d4 * d2 - this.y[n] * d3;
            this.y[n] = d4 * d3 + this.y[n] * d2;
            ++n;
        }
    }

    public void rotate(double d, double d2, double d3) {
        this.translate(-d, -d2);
        this.rotate(d3);
        this.translate(d, d2);
    }

    public void set(int n, double[] dArray, double[] dArray2) {
        this.nbPts = n;
        dArray = new double[this.nbPts];
        dArray2 = new double[this.nbPts];
        int n2 = 0;
        while (n2 < this.nbPts) {
            this.x[n2] = dArray[n2];
            this.y[n2] = dArray2[n2];
            ++n2;
        }
    }

    public double sumRectBackward() {
        double d = 0.0;
        int n = 1;
        while (n < this.nbPts) {
            d += this.y[n] * (this.x[n] - this.x[n - 1]);
            ++n;
        }
        return d;
    }

    public double sumRectCentered() {
        double d = this.y[0] * (this.x[1] - this.x[0]) / 2.0;
        int n = 1;
        while (n < this.nbPts - 1) {
            d += this.y[n] * (this.x[n + 1] - this.x[n - 1]) / 2.0;
            ++n;
        }
        return d += this.y[this.nbPts - 1] * (this.x[this.nbPts - 1] - this.x[this.nbPts - 2]) / 2.0;
    }

    public double sumRectForward() {
        double d = 0.0;
        int n = 0;
        while (n < this.nbPts - 1) {
            d += this.y[n] * (this.x[n + 1] - this.x[n]);
            ++n;
        }
        return d;
    }

    public double sumTrapez() {
        double d = 0.0;
        int n = 0;
        while (n < this.nbPts - 1) {
            d += (this.y[n] + this.y[n + 1]) / 2.0 * (this.x[n + 1] - this.x[n]);
            ++n;
        }
        return d;
    }

    public String toString() {
        String string = "Data2D";
        return string;
    }

    public void translate(double d, double d2) {
        int n = 0;
        while (n < this.nbPts) {
            int n2 = n;
            this.x[n2] = this.x[n2] + d;
            int n3 = n++;
            this.y[n3] = this.y[n3] + d2;
        }
    }

    public void writeFileMore(WFile wFile, Pack2D pack2D) {
        wFile.writeln("N " + this.nbPts);
        wFile.writeln("Points ");
        int n = 0;
        while (n < this.nbPts) {
            wFile.writeln(String.valueOf(this.x[n]) + " " + this.y[n]);
            ++n;
        }
    }
}

