/*
 * Decompiled with CFR 0.152.
 */
package opale.module2d.noyau2d;

import java.awt.Color;
import java.awt.Graphics;
import opale.module2d.noyau2d.CoordSystem;
import opale.module2d.noyau2d.Point2D;
import opale.module2d.noyau2d.Vector2D;

public class Pen2D {
    private CoordSystem repere;
    private Graphics g;
    private Color couleur;

    public Pen2D(Graphics graphics, CoordSystem coordSystem) {
        this.repere = coordSystem;
        this.g = graphics;
    }

    public void clip() {
        this.g.setClip(this.repere.getXinf(), this.repere.getYinf(), this.repere.getWidth(), this.repere.getHeight());
    }

    public void drawArrow(double d, double d2, double d3, double d4, int n) {
        int n2;
        int n3 = this.repere.X(d3, d4);
        int n4 = this.repere.Y(d3, d4);
        int n5 = this.repere.X(d, d2);
        double d5 = Vector2D.norm(n3 - n5, n4 - (n2 = this.repere.Y(d, d2)));
        if (d5 != 0.0) {
            double d6 = (double)(-(n4 - n2)) / d5;
            double d7 = (double)(n3 - n5) / d5;
            double d8 = (double)n3 - (double)n * d7;
            double d9 = (double)n4 + (double)n * d6;
            this.g.drawLine((int)(d8 + d6 * 5.0), (int)(d9 + d7 * 5.0), n3, n4);
            this.g.drawLine((int)(d8 - d6 * 5.0), (int)(d9 - d7 * 5.0), n3, n4);
        }
    }

    public void drawCircle(double d, double d2, double d3) {
        if (d3 >= 0.0) {
            this.g.drawOval(this.repere.X(d - d3, d2 + d3), this.repere.Y(d - d3, d2 + d3), Math.abs(this.repere.X(d3 * 2.0, 0.0) - this.repere.X(0.0, 0.0)), Math.abs(this.repere.Y(0.0, d3 * 2.0) - this.repere.Y(0.0, 0.0)));
        }
    }

    public void drawCircle(double d, double d2, int n) {
        this.g.drawOval(this.repere.X(d, d2) - (n >> 1), this.repere.Y(d, d2) - (n >> 1), n, n);
    }

    public void drawDiamond(double d, double d2, int n) {
        int n2 = this.repere.X(d, d2);
        int n3 = this.repere.Y(d, d2);
        this.g.drawLine(n2 + n, n3, n2, n3 + n);
        this.g.drawLine(n2, n3 + n, n2 - n, n3);
        this.g.drawLine(n2 - n, n3, n2, n3 - n);
        this.g.drawLine(n2, n3 - n, n2 + n, n3);
    }

    public void drawHLine(double d) {
        this.drawLine(this.repere.getXmin(), d, this.repere.getXmax(), d);
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        this.g.drawLine(this.repere.X(d, d2), this.repere.Y(d, d2), this.repere.X(d3, d4), this.repere.Y(d3, d4));
    }

    public void drawLine(Point2D point2D, Point2D point2D2) {
        this.drawLine(point2D.x, point2D.y, point2D2.x, point2D2.y);
    }

    public void drawPlus(double d, double d2, int n) {
        this.g.drawLine(this.repere.X(d, d2) - n, this.repere.Y(d, d2), this.repere.X(d, d2) + n, this.repere.Y(d, d2));
        this.g.drawLine(this.repere.X(d, d2), this.repere.Y(d, d2) - n, this.repere.X(d, d2), this.repere.Y(d, d2) + n);
    }

    public void drawPoint(double d, double d2) {
        this.drawLine(d, d2, d, d2);
    }

    public void drawRect(double d, double d2, double d3, double d4) {
        this.g.drawRect(this.repere.X(d, d2), this.repere.Y(d, d2), this.repere.X(d3, 0.0), this.repere.Y(0.0, d4));
    }

    public void drawSquare(double d, double d2, int n) {
        this.g.drawRect(this.repere.X(d, d2) - (n >> 1), this.repere.Y(d, d2) - (n >> 1), n, n);
    }

    public void drawString(String string, double d, double d2) {
        this.g.drawString(string, this.repere.X(d, d2), this.repere.Y(d, d2));
    }

    public void drawString(String string, double d, double d2, int n, int n2) {
        this.g.drawString(string, this.repere.X(d, d2) + n, this.repere.Y(d, d2) + n2);
    }

    public void drawTriangleDown(double d, double d2, int n) {
        int n2 = this.repere.X(d, d2);
        int n3 = this.repere.Y(d, d2);
        int n4 = (int)Math.round(0.58 * (double)n);
        this.g.drawLine(n2, n3 + 2 * n4, n2 + n, n3 - n4);
        this.g.drawLine(n2 + n, n3 - n4, n2 - n, n3 - n4);
        this.g.drawLine(n2 - n, n3 - n4, n2, n3 + 2 * n4);
    }

    public void drawTriangleLeft(double d, double d2, int n) {
        int n2 = this.repere.X(d, d2);
        int n3 = this.repere.Y(d, d2);
        int n4 = (int)Math.round(0.58 * (double)n);
        this.g.drawLine(n2 + n4, n3 - n, n2 + n4, n3 + n);
        this.g.drawLine(n2 + n4, n3 + n, n2 - 2 * n4, n3);
        this.g.drawLine(n2 - 2 * n4, n3, n2 + n4, n3 - n);
    }

    public void drawTriangleRight(double d, double d2, int n) {
        int n2 = this.repere.X(d, d2);
        int n3 = this.repere.Y(d, d2);
        int n4 = (int)Math.round(0.58 * (double)n);
        this.g.drawLine(n2 - n4, n3 - n, n2 - n4, n3 + n);
        this.g.drawLine(n2 - n4, n3 + n, n2 + 2 * n4, n3);
        this.g.drawLine(n2 + 2 * n4, n3, n2 - n4, n3 - n);
    }

    public void drawTriangleUp(double d, double d2, int n) {
        int n2 = this.repere.X(d, d2);
        int n3 = this.repere.Y(d, d2);
        int n4 = (int)Math.round(0.58 * (double)n);
        this.g.drawLine(n2, n3 - 2 * n4, n2 + n, n3 + n4);
        this.g.drawLine(n2 + n, n3 + n4, n2 - n, n3 + n4);
        this.g.drawLine(n2 - n, n3 + n4, n2, n3 - 2 * n4);
    }

    public void drawVLine(double d) {
        this.drawLine(d, this.repere.getYmin(), d, this.repere.getYmax());
    }

    public void drawX(double d, double d2, int n) {
        this.g.drawLine(this.repere.X(d, d2) - n, this.repere.Y(d, d2) - n, this.repere.X(d, d2) + n, this.repere.Y(d, d2) + n);
        this.g.drawLine(this.repere.X(d, d2) - n, this.repere.Y(d, d2) + n, this.repere.X(d, d2) + n, this.repere.Y(d, d2) - n);
    }

    public void drawXtick(double d, double d2, int n) {
        int n2 = this.repere.X(d, d2);
        int n3 = this.repere.Y(d, d2);
        this.g.drawLine(n2 - n, n3, n2 + n, n3);
    }

    public void drawYtick(double d, double d2, int n) {
        int n2 = this.repere.X(d, d2);
        int n3 = this.repere.Y(d, d2);
        this.g.drawLine(n2, -n + n3, n2, n + n3);
    }

    public Color getColor() {
        return this.couleur;
    }

    public CoordSystem getCoordSyst() {
        return this.repere;
    }

    public void setColor(Color color) {
        this.couleur = color;
        this.g.setColor(color);
    }
}

